/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.saml;

import com.intellij.hub.core.Error;
import com.intellij.hub.core.ErrorImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensaml.common.SAMLException;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/saml/HubSAMLException;", "Lorg/opensaml/common/SAMLException;", "code", "", "error", "", "message", "(ILjava/lang/String;Ljava/lang/String;)V", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Exception;)V", "getCode", "()I", "getError", "()Ljava/lang/String;", "toError", "Lcom/intellij/hub/core/Error;", "Companion", "jetbrains.jetpass.saml"})
public final class HubSAMLException
extends SAMLException {
    private final int code;
    @NotNull
    private final String error;
    public static final Companion Companion = new Companion(null);

    public final int getCode() {
        return this.code;
    }

    @NotNull
    public final String getError() {
        return this.error;
    }

    @NotNull
    public final Error toError() {
        String string = this.getMessage();
        if (string == null) {
            string = this.error;
        }
        return (Error)new ErrorImpl(this.error, this.code, string, this.getMessage(), null, null, 48, null);
    }

    public HubSAMLException(int code, @NotNull String error, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        super(message);
        this.code = code;
        this.error = error;
    }

    public HubSAMLException(int code, @NotNull String error, @NotNull String message, @NotNull Exception cause) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        super(message, cause);
        this.code = code;
        this.error = error;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0012\u0010\b\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0012\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0012\u0010\n\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0012\u0010\u000b\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0004J\u001a\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u0014\u001a\u00020\u0004J\u001a\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000e2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u0018\u001a\u00020\u0004J\u001e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e\u00a8\u0006\u001c"}, d2={"Ljetbrains/jetpass/saml/HubSAMLException$Companion;", "", "()V", "cantBuildResponse", "Ljetbrains/jetpass/saml/HubSAMLException;", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cantDecodeBase64Request", "cantDeflateRequest", "cantParseXMLRequest", "cantUnmarshallRequest", "emailRequired", "login", "", "emailUnverified", "missingSAMLRequestParameter", "oauthError", "code", "description", "stateMismatch", "unregisteredServiceProvider", "issuer", "acsURL", "unresolvedOAuthCode", "wrongACSUrl", "expectedURL", "actualURL", "jetbrains.jetpass.saml"})
    public static final class Companion {
        @NotNull
        public final HubSAMLException cantDecodeBase64Request(@NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new HubSAMLException(400, "saml_malformed_request", "Cannot decode SAML request base64: " + cause.getMessage(), cause);
        }

        @NotNull
        public final HubSAMLException cantDeflateRequest(@NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new HubSAMLException(400, "saml_malformed_request", "Cannot deflate SAML request: " + cause.getMessage(), cause);
        }

        @NotNull
        public final HubSAMLException cantParseXMLRequest(@NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new HubSAMLException(400, "saml_malformed_request", "Cannot parse SAML request XML: " + cause.getMessage(), cause);
        }

        @NotNull
        public final HubSAMLException cantUnmarshallRequest(@NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new HubSAMLException(400, "saml_malformed_request", "Cannot unmarshall SAML authn request: " + cause.getMessage(), cause);
        }

        @NotNull
        public final HubSAMLException unregisteredServiceProvider(@NotNull String issuer, @Nullable String acsURL) {
            Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
            return new HubSAMLException(400, "saml_unregistered_service_provider", "SAML 2.0 Service Provider \"" + issuer + "\" " + (acsURL != null ? " with assertion consumer URL \"" + acsURL + '\"' : "") + " is not registered");
        }

        @NotNull
        public static /* bridge */ /* synthetic */ HubSAMLException unregisteredServiceProvider$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.unregisteredServiceProvider(string, string2);
        }

        @NotNull
        public final HubSAMLException wrongACSUrl(@NotNull String issuer, @NotNull String expectedURL, @NotNull String actualURL) {
            Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
            Intrinsics.checkParameterIsNotNull((Object)expectedURL, (String)"expectedURL");
            Intrinsics.checkParameterIsNotNull((Object)actualURL, (String)"actualURL");
            return new HubSAMLException(400, "saml_bad_acs_url", "Wrong assertion consumer service URL for the service provider with issuer \"" + issuer + "\". Expected \"" + expectedURL + "\" but found \"" + actualURL + '\"');
        }

        @NotNull
        public final HubSAMLException oauthError(@Nullable String code, @Nullable String description) {
            String string;
            String string2 = code;
            if (string2 == null) {
                string2 = "saml_oauth_error";
            }
            if ((string = description) == null) {
                string = "OAuth authorization failed";
            }
            return new HubSAMLException(403, string2, string);
        }

        @NotNull
        public final HubSAMLException stateMismatch() {
            return new HubSAMLException(403, "saml_state_mismatch", "SAML authorization session state mismatch. Possible CSRF attack or page refresh");
        }

        @NotNull
        public final HubSAMLException unresolvedOAuthCode() {
            return new HubSAMLException(403, "saml_oauth_code_unresolved", "OAuth 2.0 authentication code couldn't be resolved");
        }

        @NotNull
        public final HubSAMLException emailRequired(@NotNull String login) {
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            return new HubSAMLException(400, "saml_email_required", "Cannot authenticate user \u201c" + login + "\u201d with SAML because the user has no email");
        }

        @NotNull
        public final HubSAMLException emailUnverified(@NotNull String login) {
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            return new HubSAMLException(400, "saml_email_unverified", "Cannot authenticate user \u201c" + login + "\u201d with SAML because the user's email is not verified");
        }

        @NotNull
        public final HubSAMLException cantBuildResponse(@NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new HubSAMLException(400, "saml_bad_response", "Cannot build SAML response: " + cause.getMessage(), cause);
        }

        @NotNull
        public final HubSAMLException missingSAMLRequestParameter() {
            return new HubSAMLException(400, "saml_malformed_request", "SAMLRequest query parameter is missing");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

