/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.saml;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import jetbrains.jetpass.SAMLFacade;
import jetbrains.jetpass.saml.HubSAMLException;
import jetbrains.jetpass.saml.SAMLAuthnRequest;
import jetbrains.jetpass.saml.SAMLLogoutRequest;
import jetbrains.jetpass.saml.api.ServiceProviderMetadata;
import jetbrains.jetpass.saml.response.SupportedNameIdType;
import jetbrains.jetpass.xml.XMLExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H&J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0007H&J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u000bH\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/saml/SAMLRequestReader;", "", "()V", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "getDefaultNameIDFormat", "", "readAuthnRequest", "Ljetbrains/jetpass/saml/SAMLAuthnRequest;", "input", "Ljava/io/InputStream;", "relayState", "readLogoutRequest", "Ljetbrains/jetpass/saml/SAMLLogoutRequest;", "returnTo", "resolveServiceProvider", "Ljetbrains/jetpass/saml/api/ServiceProviderMetadata;", "issuer", "readElement", "Lorg/w3c/dom/Element;", "Companion", "jetbrains.jetpass.saml"})
public abstract class SAMLRequestReader {
    private final DocumentBuilder documentBuilder = SAMLFacade.INSTANCE.getDocumentBuilderFactory().newDocumentBuilder();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SAMLAuthnRequest readAuthnRequest(@NotNull InputStream input, @Nullable String relayState) throws HubSAMLException {
        String string;
        String issuer;
        AuthnRequest authnRequest;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Element element = this.readElement(input);
        try {
            authnRequest = (AuthnRequest)XMLExtensionKt.unmarshall(element);
        }
        catch (Exception e) {
            throw (Throwable)((Object)HubSAMLException.Companion.cantUnmarshallRequest(e));
        }
        AuthnRequest authn = authnRequest;
        Companion.getLogger().debug((Function0)new Function0<String>(authn){
            final /* synthetic */ AuthnRequest $authn;

            @NotNull
            public final String invoke() {
                return "SAML AuthnRequest:\n" + XMLHelper.prettyPrintXML((Node)this.$authn.getDOM());
            }
            {
                this.$authn = authnRequest;
                super(0);
            }
        });
        Issuer issuer2 = authn.getIssuer();
        Intrinsics.checkExpressionValueIsNotNull((Object)issuer2, (String)"authn.issuer");
        String string2 = issuer = issuer2.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"issuer");
        ServiceProviderMetadata serviceProviderMetadata = this.resolveServiceProvider(string2);
        if (serviceProviderMetadata == null) {
            throw (Throwable)((Object)HubSAMLException.Companion.unregisteredServiceProvider(issuer, authn.getAssertionConsumerServiceURL()));
        }
        ServiceProviderMetadata serviceProvider = serviceProviderMetadata;
        String actual = string = authn.getAssertionConsumerServiceURL();
        String expected = serviceProvider.getAssertionConsumerUrl();
        if (actual != null && expected != null && Intrinsics.areEqual((Object)actual, (Object)expected) ^ true) {
            throw (Throwable)((Object)HubSAMLException.Companion.wrongACSUrl(issuer, expected, actual));
        }
        String string3 = expected;
        if (string3 == null) {
            throw (Throwable)new NullPointerException("Assertion consumer URL of the service provider " + issuer + " shouldn't be empty");
        }
        String acsUrl = string3;
        String string4 = authn.getID();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"authn.id");
        String string5 = acsUrl;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"acsUrl");
        Object object = authn.getNameIDPolicy();
        if (object == null || (object = object.getFormat()) == null) {
            object = this.getDefaultNameIDFormat();
        }
        SupportedNameIdType supportedNameIdType = SupportedNameIdType.Companion.decode((String)object);
        DateTime dateTime = authn.getIssueInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"authn.issueInstant");
        return new SAMLAuthnRequest(string4, string5, issuer, supportedNameIdType, dateTime, relayState, false, serviceProvider.getLoginAttributeName(), serviceProvider.getFullNameAttributeName(), serviceProvider.getEmailAttributeName(), serviceProvider.getGroupsAttributeName());
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SAMLAuthnRequest readAuthnRequest$default(SAMLRequestReader sAMLRequestReader, InputStream inputStream, String string, int n, Object object) throws HubSAMLException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readAuthnRequest");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return sAMLRequestReader.readAuthnRequest(inputStream, string);
    }

    @NotNull
    public final SAMLLogoutRequest readLogoutRequest(@NotNull InputStream input, @Nullable String returnTo) throws HubSAMLException {
        String issuer;
        LogoutRequest logoutRequest;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Element element = this.readElement(input);
        try {
            logoutRequest = (LogoutRequest)XMLExtensionKt.unmarshall(element);
        }
        catch (Exception e) {
            throw (Throwable)((Object)HubSAMLException.Companion.cantUnmarshallRequest(e));
        }
        LogoutRequest logout = logoutRequest;
        Companion.getLogger().debug((Function0)new Function0<String>(logout){
            final /* synthetic */ LogoutRequest $logout;

            @NotNull
            public final String invoke() {
                return "SAML LogoutRequest:\n" + XMLHelper.prettyPrintXML((Node)this.$logout.getDOM());
            }
            {
                this.$logout = logoutRequest;
                super(0);
            }
        });
        Issuer issuer2 = logout.getIssuer();
        Intrinsics.checkExpressionValueIsNotNull((Object)issuer2, (String)"logout.issuer");
        String string = issuer = issuer2.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"issuer");
        ServiceProviderMetadata serviceProviderMetadata = this.resolveServiceProvider(string);
        if (serviceProviderMetadata == null) {
            throw (Throwable)((Object)HubSAMLException.Companion.unregisteredServiceProvider$default(HubSAMLException.Companion, issuer, null, 2, null));
        }
        ServiceProviderMetadata serviceProvider = serviceProviderMetadata;
        String string2 = serviceProvider.getAssertionConsumerUrl();
        if (string2 == null) {
            throw (Throwable)new NullPointerException("Assertion consumer URL of the service provider " + issuer + " shouldn't be empty");
        }
        String acsURL = string2;
        String string3 = logout.getID();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"logout.id");
        String string4 = acsURL;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"acsURL");
        Boolean bl = serviceProvider.isLogoutResponseSupported();
        if (bl == null) {
            bl = false;
        }
        boolean bl2 = bl;
        NameID nameID = logout.getNameID();
        Intrinsics.checkExpressionValueIsNotNull((Object)nameID, (String)"logout.nameID");
        String string5 = nameID.getFormat();
        if (string5 == null) {
            string5 = this.getDefaultNameIDFormat();
        }
        SupportedNameIdType supportedNameIdType = SupportedNameIdType.Companion.decode(string5);
        NameID nameID2 = logout.getNameID();
        Intrinsics.checkExpressionValueIsNotNull((Object)nameID2, (String)"logout.nameID");
        String string6 = nameID2.getValue();
        DateTime dateTime = logout.getIssueInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"logout.issueInstant");
        return new SAMLLogoutRequest(string3, string4, bl2, issuer, supportedNameIdType, string6, dateTime, returnTo);
    }

    @NotNull
    protected final Element readElement(@NotNull InputStream $receiver) throws HubSAMLException {
        Document document;
        Document document2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            document2 = this.documentBuilder.parse($receiver);
        }
        catch (Exception e) {
            throw (Throwable)((Object)HubSAMLException.Companion.cantParseXMLRequest(e));
        }
        Document document3 = document = document2;
        Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"document");
        Element element = document3.getDocumentElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"document.documentElement");
        return element;
    }

    @Nullable
    public abstract ServiceProviderMetadata resolveServiceProvider(@NotNull String var1);

    @NotNull
    public abstract String getDefaultNameIDFormat();

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/saml/SAMLRequestReader$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.saml"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

