/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.saml.response;

import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.jetpass.api.ssl.KeyStoreData;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u001c\u001a\n \u000b*\u0004\u0018\u00010\u001d0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Ljetbrains/jetpass/saml/response/KeyStoreDataExt;", "", "keyStoreData", "Ljetbrains/jetpass/api/ssl/KeyStoreData;", "(Ljetbrains/jetpass/api/ssl/KeyStoreData;)V", "certificate", "Ljava/security/cert/X509Certificate;", "getCertificate", "()Ljava/security/cert/X509Certificate;", "keyAlias", "", "kotlin.jvm.PlatformType", "getKeyAlias", "()Ljava/lang/String;", "getKeyStoreData", "()Ljetbrains/jetpass/api/ssl/KeyStoreData;", "password", "", "getPassword", "()[C", "privateKey", "Ljava/security/PrivateKey;", "getPrivateKey", "()Ljava/security/PrivateKey;", "publicKey", "Ljava/security/PublicKey;", "getPublicKey", "()Ljava/security/PublicKey;", "store", "Ljava/security/KeyStore;", "getStore", "()Ljava/security/KeyStore;", "getCredential", "Lorg/opensaml/xml/security/credential/Credential;", "jetbrains.jetpass.saml"})
public final class KeyStoreDataExt {
    @NotNull
    private final char[] password;
    private final KeyStore store;
    private final String keyAlias;
    @NotNull
    private final KeyStoreData keyStoreData;

    @NotNull
    public final char[] getPassword() {
        return this.password;
    }

    public final KeyStore getStore() {
        return this.store;
    }

    public final String getKeyAlias() {
        return this.keyAlias;
    }

    @NotNull
    public final X509Certificate getCertificate() {
        Certificate certificate = this.store.getCertificate(this.keyAlias);
        if (!(certificate instanceof X509Certificate)) {
            certificate = null;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (x509Certificate == null) {
            throw (Throwable)new IllegalStateException("SAML SSL Key certificate is no X.509");
        }
        return x509Certificate;
    }

    @NotNull
    public final PublicKey getPublicKey() {
        Certificate certificate = this.store.getCertificate(this.keyAlias);
        Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"store.getCertificate(keyAlias)");
        PublicKey publicKey = certificate.getPublicKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"store.getCertificate(keyAlias).publicKey");
        return publicKey;
    }

    @NotNull
    public final PrivateKey getPrivateKey() {
        Key key = this.store.getKey(this.keyAlias, this.password);
        if (!(key instanceof PrivateKey)) {
            key = null;
        }
        PrivateKey privateKey = (PrivateKey)key;
        if (privateKey == null) {
            throw (Throwable)new IllegalStateException("SAML SSL Key is not a private key");
        }
        return privateKey;
    }

    @NotNull
    public final Credential getCredential() {
        BasicX509Credential basicX509Credential = SecurityHelper.getSimpleCredential((X509Certificate)this.getCertificate(), (PrivateKey)this.getPrivateKey());
        Intrinsics.checkExpressionValueIsNotNull((Object)basicX509Credential, (String)"SecurityHelper.getSimple\u2026(certificate, privateKey)");
        return (Credential)basicX509Credential;
    }

    @NotNull
    public final KeyStoreData getKeyStoreData() {
        return this.keyStoreData;
    }

    /*
     * WARNING - void declaration
     */
    public KeyStoreDataExt(@NotNull KeyStoreData keyStoreData) {
        Object element$iv2;
        Object object;
        block2: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)keyStoreData, (String)"keyStoreData");
            this.keyStoreData = keyStoreData;
            String string = this.keyStoreData.getPassword();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keyStoreData.password");
            Object object2 = string;
            KeyStoreDataExt keyStoreDataExt = this;
            String string2 = object2;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            object = cArray;
            keyStoreDataExt.password = object;
            object2 = KeyStore.getInstance("PKCS12");
            keyStoreDataExt = this;
            Enumeration<String> $receiver = object2;
            ByteArrayInputStream inp = new ByteArrayInputStream(Base64.decodeBase64((String)this.keyStoreData.getBytes()));
            ((KeyStore)((Object)$receiver)).load(inp, this.password);
            inp.close();
            object = object2;
            keyStoreDataExt.store = object;
            Enumeration<String> enumeration = this.store.aliases();
            Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"store.aliases()");
            object2 = enumeration;
            keyStoreDataExt = this;
            object = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(object2));
            object2 = object;
            for (Object element$iv2 : $receiver$iv) {
                String it = (String)element$iv2;
                if (!this.store.isKeyEntry(it)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        object = element$iv2;
        keyStoreDataExt.keyAlias = (String)object;
    }
}

