/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.FileByteIterable;
import jetbrains.exodus.FixedLengthByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import org.jetbrains.annotations.NotNull;

class Cluster {
    private final ByteIterator iterator;
    private long clusterNumber;
    private int size;

    Cluster(@NotNull ByteIterable it) {
        this.iterator = it instanceof FixedLengthByteIterable ? ((FixedLengthByteIterable)it).getSource().iterator() : it.iterator();
        this.clusterNumber = 0L;
        this.size = IntegerBinding.readCompressed((ByteIterator)this.iterator);
    }

    long getClusterNumber() {
        return this.clusterNumber;
    }

    void setClusterNumber(long clusterNumber) {
        this.clusterNumber = clusterNumber;
    }

    int getSize() {
        return this.size;
    }

    boolean hasNext() {
        return this.size > 0 && this.iterator.hasNext();
    }

    byte next() {
        byte result = this.iterator.next();
        --this.size;
        return result;
    }

    long skip(long length) {
        long skipped = length > (long)this.size ? (long)this.size : this.iterator.skip(length);
        this.size -= (int)skipped;
        return skipped;
    }

    void copyTo(@NotNull byte[] array) {
        int i = 0;
        while (this.hasNext()) {
            array[i++] = this.next();
        }
    }

    static ByteIterable writeCluster(@NotNull byte[] cluster, int size, boolean accumulateInRAM) {
        ArrayByteIterable bi;
        if (accumulateInRAM) {
            bi = new ArrayByteIterable(cluster, size);
        } else {
            try {
                File file = File.createTempFile("~exodus-vfs-output-cluster", ".tmp");
                try (RandomAccessFile out = new RandomAccessFile(file, "rw");){
                    out.write(cluster, 0, size);
                }
                bi = new FileByteIterable(file);
                file.deleteOnExit();
            }
            catch (IOException e) {
                throw ExodusException.toExodusException((Throwable)e);
            }
        }
        return new CompoundByteIterable(new ByteIterable[]{IntegerBinding.intToCompressedEntry((int)size), bi});
    }
}

