/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.vfs.Cluster;
import jetbrains.exodus.vfs.ClusterKey;
import jetbrains.exodus.vfs.File;
import org.jetbrains.annotations.NotNull;

class ClusterIterator {
    private final long fd;
    private final Cursor cursor;
    private Cluster currentCluster;
    private boolean isClosed;

    ClusterIterator(@NotNull Transaction txn, @NotNull File file, @NotNull Store contents) {
        this(txn, file.getDescriptor(), contents);
    }

    ClusterIterator(@NotNull Transaction txn, long fileDescriptor, @NotNull Store contents) {
        this.fd = fileDescriptor;
        this.cursor = contents.openCursor(txn);
        ByteIterable it = this.cursor.getSearchKeyRange((ByteIterable)ClusterKey.toByteIterable(this.fd, 0L));
        if (it == null) {
            this.currentCluster = null;
        } else {
            this.currentCluster = new Cluster(it);
            this.adjustCurrentCluster();
        }
        this.isClosed = false;
    }

    boolean hasCluster() {
        return this.currentCluster != null;
    }

    Cluster getCurrent() {
        return this.currentCluster;
    }

    void moveToNext() {
        if (this.currentCluster != null) {
            if (!this.cursor.getNext()) {
                this.currentCluster = null;
            } else {
                this.currentCluster = new Cluster(this.cursor.getValue());
                this.adjustCurrentCluster();
            }
        }
    }

    void deleteCurrent() {
        if (this.currentCluster != null) {
            this.cursor.deleteCurrent();
        }
    }

    void close() {
        if (!this.isClosed) {
            this.cursor.close();
            this.isClosed = true;
        }
    }

    boolean isClosed() {
        return this.isClosed;
    }

    private void adjustCurrentCluster() {
        ClusterKey clusterKey = new ClusterKey(this.cursor.getKey());
        if (clusterKey.getDescriptor() != this.fd) {
            this.currentCluster = null;
        } else {
            this.currentCluster.setClusterNumber(clusterKey.getClusterNumber());
        }
    }
}

