/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

class ClusterKey {
    private final long fd;
    private final long clusterNumber;

    ClusterKey(@NotNull ByteIterable iterable) {
        ByteIterator iterator = iterable.iterator();
        this.fd = LongBinding.readCompressed((ByteIterator)iterator);
        this.clusterNumber = LongBinding.readCompressed((ByteIterator)iterator);
    }

    long getDescriptor() {
        return this.fd;
    }

    long getClusterNumber() {
        return this.clusterNumber;
    }

    static ArrayByteIterable toByteIterable(long fd, long clusterNumber) {
        LightOutputStream output = new LightOutputStream();
        LongBinding.writeCompressed((LightOutputStream)output, (long)fd);
        LongBinding.writeCompressed((LightOutputStream)output, (long)clusterNumber);
        return output.asArrayByteIterable();
    }
}

