/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

public abstract class ClusteringStrategy {
    public static final ClusteringStrategy LINEAR = new LinearClusteringStrategy();
    public static final ClusteringStrategy QUADRATIC = new QuadraticClusteringStrategy();
    public static final ClusteringStrategy EXPONENTIAL = new ExponentialClusteringStrategy();
    private int maxClusterSize = Integer.MAX_VALUE;

    abstract int getFirstClusterSize();

    abstract int getNextClusterSize(int var1);

    abstract long getNextClusterNumber(long var1);

    public void setMaxClusterSize(int maxClusterSize) {
        this.maxClusterSize = maxClusterSize;
    }

    protected int adjustClusterSize(int nextClusterSize) {
        return nextClusterSize > this.maxClusterSize ? this.maxClusterSize : nextClusterSize;
    }

    public static class ExponentialClusteringStrategy
    extends DefaultInitialClusteringStrategy {
        public ExponentialClusteringStrategy() {
        }

        public ExponentialClusteringStrategy(int firstClusterSize) {
            super(firstClusterSize);
        }

        @Override
        int getNextClusterSize(int prevClusterSize) {
            return this.adjustClusterSize((prevClusterSize << 3) / 5);
        }
    }

    public static class QuadraticClusteringStrategy
    extends DefaultInitialClusteringStrategy {
        public QuadraticClusteringStrategy() {
        }

        public QuadraticClusteringStrategy(int firstClusterSize) {
            super(firstClusterSize);
        }

        @Override
        int getNextClusterSize(int prevClusterSize) {
            return this.adjustClusterSize(prevClusterSize + this.firstClusterSize);
        }
    }

    public static class LinearClusteringStrategy
    extends DefaultInitialClusteringStrategy {
        public LinearClusteringStrategy() {
        }

        public LinearClusteringStrategy(int firstClusterSize) {
            super(firstClusterSize);
        }

        @Override
        int getNextClusterSize(int prevClusterSize) {
            return prevClusterSize;
        }
    }

    private static abstract class DefaultInitialClusteringStrategy
    extends ClusteringStrategy {
        private static final int DEFAULT_FIRST_CLUSTER_SIZE = 4096;
        private static final long DEFAULT_CLUSTER_NUMBER_DELTA = 1024L;
        protected final int firstClusterSize;

        protected DefaultInitialClusteringStrategy() {
            this(4096);
        }

        protected DefaultInitialClusteringStrategy(int firstClusterSize) {
            this.firstClusterSize = firstClusterSize;
        }

        @Override
        int getFirstClusterSize() {
            return this.firstClusterSize;
        }

        @Override
        long getNextClusterNumber(long clusterNumber) {
            return clusterNumber + 1024L;
        }
    }
}

