/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import java.io.IOException;
import java.io.InputStream;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.vfs.Cluster;
import jetbrains.exodus.vfs.ClusterIterator;
import jetbrains.exodus.vfs.VfsException;
import jetbrains.exodus.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;

public class VfsInputStream
extends InputStream {
    private final ClusterIterator clusterIterator;

    VfsInputStream(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fileDescriptor) {
        this(vfs, txn, fileDescriptor, 0L);
    }

    VfsInputStream(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fileDescriptor, long position) {
        this.clusterIterator = new ClusterIterator(txn, fileDescriptor, vfs.getContents());
        while (this.clusterIterator.hasCluster()) {
            Cluster currentCluster = this.clusterIterator.getCurrent();
            int clusterSize = currentCluster.getSize();
            if (position < (long)clusterSize) {
                long skipped = currentCluster.skip(position);
                if (skipped == position) break;
                throw new VfsException();
            }
            position -= (long)clusterSize;
            this.clusterIterator.moveToNext();
        }
    }

    @Override
    public int read() throws IOException {
        while (true) {
            if (!this.clusterIterator.hasCluster()) {
                return -1;
            }
            if (this.clusterIterator.getCurrent().hasNext()) break;
            this.clusterIterator.moveToNext();
        }
        return this.clusterIterator.getCurrent().next() & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.clusterIterator.close();
    }

    public boolean isOpen() {
        return !this.clusterIterator.isClosed();
    }

    @Override
    public long skip(long n) {
        long skipped = 0L;
        while (this.clusterIterator.hasCluster() && (skipped += this.clusterIterator.getCurrent().skip(n - skipped)) != n) {
            this.clusterIterator.moveToNext();
        }
        return skipped;
    }
}

