/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LauncherArgumentsParser;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.Commands;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.ep.commands.Usage;
import com.jetbrains.launcher.log.LoggerMode;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCompositeCommand
extends BaseCommand {
    @NotNull
    private final List<BaseCommand> mySubCommands;
    private final int mySubCommandIndex;

    protected BaseCompositeCommand(BaseCommand ... subCommands) {
        if (subCommands == null) {
            BaseCompositeCommand.$$$reportNull$$$0(0);
        }
        this(1, subCommands);
    }

    protected BaseCompositeCommand(int subCommandIndex, BaseCommand ... subCommands) {
        if (subCommands == null) {
            BaseCompositeCommand.$$$reportNull$$$0(1);
        }
        this.mySubCommands = Arrays.asList(subCommands);
        this.mySubCommandIndex = subCommandIndex;
    }

    @Override
    public boolean isAvailable(@NotNull Arguments args) {
        if (args == null) {
            BaseCompositeCommand.$$$reportNull$$$0(2);
        }
        for (BaseCommand subCommand : this.mySubCommands) {
            if (!subCommand.isAvailable(args)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected BaseCommand getActualCommand(@NotNull Arguments args) {
        if (args == null) {
            BaseCompositeCommand.$$$reportNull$$$0(3);
        }
        BaseCommand baseCommand = Commands.getCommand(this, args.getSubCommandName(this.mySubCommandIndex), this.mySubCommands, args).getActualCommand(args);
        if (baseCommand == null) {
            BaseCompositeCommand.$$$reportNull$$$0(4);
        }
        return baseCommand;
    }

    @Override
    @Nullable
    public LauncherArgumentsParser.State next(@NotNull String arg) {
        if (arg == null) {
            BaseCompositeCommand.$$$reportNull$$$0(5);
        }
        return Commands.findCommand(arg, this.mySubCommands, null);
    }

    @Override
    @Nullable
    public Command findSubCommand(@NotNull String subCommandName, @NotNull Arguments args) {
        if (subCommandName == null) {
            BaseCompositeCommand.$$$reportNull$$$0(6);
        }
        if (args == null) {
            BaseCompositeCommand.$$$reportNull$$$0(7);
        }
        return Commands.findCommand(subCommandName, this.mySubCommands, args);
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            BaseCompositeCommand.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) {
        if (context == null) {
            BaseCompositeCommand.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException();
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            BaseCompositeCommand.$$$reportNull$$$0(10);
        }
        if (context == null) {
            BaseCompositeCommand.$$$reportNull$$$0(11);
        }
        if (this.mySubCommands.size() == 1) {
            this.mySubCommands.get(0).printUsage(printer, context);
        } else {
            printer.print(this.getFullName(), this.getUsageDescription(context));
        }
    }

    @NotNull
    protected String getUsageDescription(@NotNull LauncherContext context) {
        if (context == null) {
            BaseCompositeCommand.$$$reportNull$$$0(12);
        }
        String string = this.getComplexCommandUsageText();
        if (string == null) {
            BaseCompositeCommand.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            BaseCompositeCommand.$$$reportNull$$$0(14);
        }
        if (context == null) {
            BaseCompositeCommand.$$$reportNull$$$0(15);
        }
        if (this.mySubCommands.size() == 1) {
            this.mySubCommands.get(0).printStandaloneUsage(printer, context);
        } else {
            if (this.getType(context.getArguments()) == Command.CommandType.DEV_COMMAND) {
                Usage.printCommands(printer, this.mySubCommands, Command.CommandType.DEV_COMMAND, context);
            } else {
                Usage.printCommands(printer, this.mySubCommands, context);
            }
            this.printAdditionalStandaloneUsageInfo();
        }
    }

    protected void printAdditionalStandaloneUsageInfo() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subCommands";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/BaseCompositeCommand";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subCommandName";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/BaseCompositeCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualCommand";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActualCommand";
                break;
            }
            case 4: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "next";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSubCommand";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUsageDescription";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

