/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.run.AgentDiagnosticFacade;
import com.jetbrains.launcher.run.AgentStartFacade;
import com.jetbrains.launcher.util.ExceptionUtil;
import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

abstract class BaseDumpSubCommand
extends BaseCommand {
    @NotNull
    protected static final String SHORT = "short";
    @NotNull
    private final Logger LOG = Logger.getLogger(BaseDumpSubCommand.class);

    BaseDumpSubCommand() {
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = "dump " + this.getName();
        if (string == null) {
            BaseDumpSubCommand.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void collectPossibleArgs(@NotNull Set<String> possibleArgs) {
        if (possibleArgs == null) {
            BaseDumpSubCommand.$$$reportNull$$$0(1);
        }
        possibleArgs.add(SHORT);
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        LauncherExitCode launcherExitCode;
        AgentStartFacade agentFacade;
        AgentDiagnosticFacade diagnosticFacade;
        if (context == null) {
            BaseDumpSubCommand.$$$reportNull$$$0(2);
        }
        if ((diagnosticFacade = (agentFacade = context.createAgentFacade()).getDiagnosticFacade()) == null) {
            this.LOG.error((Object)("Cannot dump " + this.getName() + ": operation is not supported"));
            LauncherExitCode launcherExitCode2 = LauncherExitCode.ERROR;
            if (launcherExitCode2 == null) {
                BaseDumpSubCommand.$$$reportNull$$$0(3);
            }
            return launcherExitCode2;
        }
        AppName appName = context.getAppConfig().getAppName();
        AppState appState = context.getAppState();
        if (appState == null || !appState.isRunState()) {
            this.LOG.error((Object)("Cannot dump " + this.getName() + ": " + appName.getCapitalizedName() + " is not running"));
            LauncherExitCode launcherExitCode3 = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode3 == null) {
                BaseDumpSubCommand.$$$reportNull$$$0(4);
            }
            return launcherExitCode3;
        }
        try {
            this.dump(context.getArguments(), diagnosticFacade);
            launcherExitCode = LauncherExitCode.OK;
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)("Failed to dump " + appName.getName() + " " + this.getName()), (Throwable)e);
            LauncherExitCode launcherExitCode4 = LauncherExitCode.ERROR;
            if (launcherExitCode4 == null) {
                BaseDumpSubCommand.$$$reportNull$$$0(6);
            }
            return launcherExitCode4;
        }
        if (launcherExitCode == null) {
            BaseDumpSubCommand.$$$reportNull$$$0(5);
        }
        return launcherExitCode;
    }

    protected abstract void dump(@NotNull Arguments var1, @NotNull AgentDiagnosticFacade var2) throws IOException;

    protected static boolean isShort(@NotNull Arguments args) {
        if (args == null) {
            BaseDumpSubCommand.$$$reportNull$$$0(7);
        }
        return args.containsLauncherParam(SHORT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/BaseDumpSubCommand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleArgs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/BaseDumpSubCommand";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleArgs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isShort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

