/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseJavaSubCommand;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.JavaUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JavaSet
extends BaseJavaSubCommand {
    @NotNull
    private static final String NAME = "set";
    @NotNull
    private final Logger LOG = Logger.getLogger(JavaSet.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            JavaSet.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        List args;
        if (context == null) {
            JavaSet.$$$reportNull$$$0(1);
        }
        if ((args = context.getArguments().getApplicationArguments()).isEmpty()) {
            throw new IllegalArgumentException();
        }
        File path = new File((String)args.get(0));
        if (!path.exists()) {
            this.LOG.error((Object)("Path does not exist: " + path.getAbsolutePath()));
            LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
            if (launcherExitCode == null) {
                JavaSet.$$$reportNull$$$0(2);
            }
            return launcherExitCode;
        }
        if (path.isDirectory()) {
            path = JavaUtil.getJavaExecutable((File)path, (boolean)false);
        }
        if (!JavaUtil.isJavaExecutable((File)path)) {
            this.LOG.error((Object)("Invalid Java executable: " + path.getAbsolutePath()));
            LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
            if (launcherExitCode == null) {
                JavaSet.$$$reportNull$$$0(3);
            }
            return launcherExitCode;
        }
        try {
            FileUtil.saveText((File)context.getAppFiles().getJavaHintFile(), (String)path.getAbsolutePath());
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)"Failed to set Java path", (Throwable)e);
            LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
            if (launcherExitCode == null) {
                JavaSet.$$$reportNull$$$0(4);
            }
            return launcherExitCode;
        }
        LauncherExitCode launcherExitCode = LauncherExitCode.OK;
        if (launcherExitCode == null) {
            JavaSet.$$$reportNull$$$0(5);
        }
        return launcherExitCode;
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            JavaSet.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JavaSet.$$$reportNull$$$0(7);
        }
        printer.print(this.getFullName() + " <path to Java home or Java executable>", "sets the specified Java to be explicitly used by " + context.getAppConfig().getAppName().getName() + " if it has proper version and attributes");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/JavaSet";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/JavaSet";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

