/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseLauncherDumpSubCommand;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.JavaUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherDumpThreads
extends BaseLauncherDumpSubCommand {
    @NotNull
    public static final String NAME = "threads";
    @NotNull
    private static final String TO_FILE = "to-file";

    @NotNull
    public String getName() {
        if (NAME == null) {
            LauncherDumpThreads.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    protected void collectPossibleArgs(@NotNull Set<String> possibleArgs) {
        if (possibleArgs == null) {
            LauncherDumpThreads.$$$reportNull$$$0(1);
        }
        super.collectPossibleArgs(possibleArgs);
        possibleArgs.add(TO_FILE);
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            LauncherDumpThreads.$$$reportNull$$$0(2);
        }
        LoggerMode loggerMode = !LauncherDumpThreads.isToFile(args) || LauncherDumpThreads.isShort(args) ? LoggerMode.CONSOLE_ERROR_ONLY : LoggerMode.CONSOLE_ONLY;
        if (loggerMode == null) {
            LauncherDumpThreads.$$$reportNull$$$0(3);
        }
        return loggerMode;
    }

    @Override
    @Nullable
    protected Integer getTimeoutSeconds() {
        return 15;
    }

    @Override
    @NotNull
    protected String[] createCmdLine(@NotNull LauncherContextEx context, int launcherPID) throws IOException {
        File jstack;
        if (context == null) {
            LauncherDumpThreads.$$$reportNull$$$0(4);
        }
        if ((jstack = JavaUtil.findJStackTool()) == null) {
            throw new IOException("Failed to find \"jstack\"");
        }
        String[] stringArray = JavaUtil.getJStackToolCommandLine((File)jstack, (int)launcherPID);
        if (stringArray == null) {
            LauncherDumpThreads.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    protected void processOutput(@NotNull LauncherContextEx context, @NotNull List<String> stdout) throws IOException {
        Arguments args;
        if (context == null) {
            LauncherDumpThreads.$$$reportNull$$$0(6);
        }
        if (stdout == null) {
            LauncherDumpThreads.$$$reportNull$$$0(7);
        }
        if (LauncherDumpThreads.isToFile(args = context.getArguments())) {
            File dumpFile = RuntimeUtil.getLauncherThreadDumpFile((AppFiles)context.getAppFiles());
            FileUtil.writeLines((File)dumpFile, stdout);
            if (LauncherDumpThreads.isShort(args)) {
                ConsoleLogger.system((String)dumpFile.getAbsolutePath());
            } else {
                ConsoleLogger.info((String)("Launcher threads were dumped to the file: " + dumpFile.getAbsolutePath()));
            }
        } else {
            for (String line : stdout) {
                ConsoleLogger.system((String)line);
            }
        }
    }

    private static boolean isToFile(@NotNull Arguments args) {
        if (args == null) {
            LauncherDumpThreads.$$$reportNull$$$0(8);
        }
        return args.containsLauncherParam(TO_FILE);
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            LauncherDumpThreads.$$$reportNull$$$0(9);
        }
        if (context == null) {
            LauncherDumpThreads.$$$reportNull$$$0(10);
        }
        printer.print(this.getFullName(), "dumps launcher threads, " + this.getComplexCommandUsageText());
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            LauncherDumpThreads.$$$reportNull$$$0(11);
        }
        if (context == null) {
            LauncherDumpThreads.$$$reportNull$$$0(12);
        }
        printer.print(this.getFullName(), "dumps launcher threads to the console");
        String toFileCommand = this.getFullName() + " " + TO_FILE;
        printer.print(toFileCommand, "dumps launcher threads to the file under the launcher logs directory");
        printer.print(toFileCommand + " " + "short", "same as \"" + toFileCommand + "\", but prints to the console nothing but the absolute path of the created file");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/LauncherDumpThreads";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleArgs";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/LauncherDumpThreads";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCmdLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleArgs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCmdLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processOutput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isToFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

