/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitAction;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.Resource;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.UserMessageTransformer;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.lock.AppLockFactory;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.lock.CannotAcquireAppLockException;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.run.AgentRunner;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.StringUtil;
import com.jetbrains.launcher.util.WindowsConsoleHandler;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Run
extends BaseCommand {
    @NotNull
    private static final String NAME = "run";
    @NotNull
    private static final String FROM_SERVICE = "from-service";
    @NotNull
    private final Logger LOG = Logger.getLogger(Run.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            Run.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("d" == null) {
            Run.$$$reportNull$$$0(1);
        }
        return "d";
    }

    @Override
    protected void collectPossibleArgs(@NotNull Set<String> possibleArgs) {
        if (possibleArgs == null) {
            Run.$$$reportNull$$$0(2);
        }
        possibleArgs.add(FROM_SERVICE);
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            Run.$$$reportNull$$$0(3);
        }
        LoggerMode loggerMode = LoggerMode.LAUNCHER_APP;
        if (loggerMode == null) {
            Run.$$$reportNull$$$0(4);
        }
        return loggerMode;
    }

    @Override
    @Nullable
    protected String getLogPrefix() {
        return null;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(final @NotNull LauncherContextEx context) throws InitException {
        LauncherExitCode launcherExitCode;
        AppName appName;
        LauncherExitCode code;
        if (context == null) {
            Run.$$$reportNull$$$0(5);
        }
        if ((code = Run.checkState(context, appName = context.getAppConfig().getAppName(), this.LOG)) != null) {
            LauncherExitCode launcherExitCode2 = code;
            if (launcherExitCode2 == null) {
                Run.$$$reportNull$$$0(6);
            }
            return launcherExitCode2;
        }
        final UpToDateLauncherContext upToDateContext = new UpToDateLauncherContext(context);
        try {
            launcherExitCode = AppLockFactory.withLock(AppLockFactory.createLock(upToDateContext), AppState.RUN, new InitAction(){

                @Override
                @NotNull
                public LauncherExitCode run() throws InitException {
                    Run.prepareConfigDistFiles(context, Run.this.LOG);
                    Arguments args = context.getArguments();
                    if (args.isConsole()) {
                        Run.setConsoleCtrlCloseHandlerIfNeeded(context, Run.this.LOG);
                    }
                    Run.this.LOG.info((Object)("Starting " + appName.getName() + "..."));
                    LauncherExitCode launcherExitCode = new AgentRunner(upToDateContext).run();
                    if (launcherExitCode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return launcherExitCode;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/commands/Run$1", Run.NAME));
                }
            });
        }
        catch (CannotAcquireAppLockException e) {
            this.LOG.error((Object)context.getIllegalAppStateErrorText(AppState.RUN));
            LauncherExitCode launcherExitCode3 = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode3 == null) {
                Run.$$$reportNull$$$0(8);
            }
            return launcherExitCode3;
        }
        if (launcherExitCode == null) {
            Run.$$$reportNull$$$0(7);
        }
        return launcherExitCode;
    }

    @Nullable
    public static LauncherExitCode checkState(@NotNull LauncherContextEx context, @NotNull AppName appName, @NotNull Logger log) throws InitException {
        AppState appState;
        if (context == null) {
            Run.$$$reportNull$$$0(9);
        }
        if (appName == null) {
            Run.$$$reportNull$$$0(10);
        }
        if (log == null) {
            Run.$$$reportNull$$$0(11);
        }
        if ((appState = context.getAppState()) != null) {
            log.error((Object)appState.getIllegalAppStateErrorText(AppState.RUN, appName));
            return LauncherExitCode.ILLEGAL_STATE;
        }
        return null;
    }

    static void prepareConfigDistFiles(@NotNull LauncherContext context, @NotNull Logger log) {
        if (context == null) {
            Run.$$$reportNull$$$0(12);
        }
        if (log == null) {
            Run.$$$reportNull$$$0(13);
        }
        AppFilesEx appFiles = context.getAppFiles();
        Run.prepareConfigDistFile(appFiles, ".launch.config.dist", log);
        if (context.getArguments().isJavaApplication()) {
            Run.prepareConfigDistFile(appFiles, ".jvmoptions.dist", log);
        }
    }

    private static void prepareConfigDistFile(@NotNull AppFilesEx appFiles, @NotNull String configDistFileNameSuffix, @NotNull Logger log) {
        Resource launcherConfigDistFile;
        if (appFiles == null) {
            Run.$$$reportNull$$$0(14);
        }
        if (configDistFileNameSuffix == null) {
            Run.$$$reportNull$$$0(15);
        }
        if (log == null) {
            Run.$$$reportNull$$$0(16);
        }
        if ((launcherConfigDistFile = appFiles.resolveLauncherAppConfigFile(configDistFileNameSuffix)).exists()) {
            try {
                String launcherConfigDistFileContent = FileUtil.loadText((URL)launcherConfigDistFile.getURL());
                File appConfigDistFile = appFiles.getAppConfigFile(configDistFileNameSuffix);
                if (appConfigDistFile.isFile()) {
                    Run.checkAppConfigDistFileContent(appConfigDistFile, launcherConfigDistFileContent, log);
                }
                FileUtil.saveText((File)appConfigDistFile, (String)launcherConfigDistFileContent);
            }
            catch (IOException e) {
                log.debug((Object)ExceptionUtil.buildMessage((String)"Failed to update config dist file", (Throwable)e), (Throwable)e);
            }
        } else {
            log.debug((Object)("Failed to update config dist file: original config dist file is not found: " + launcherConfigDistFile.getURL().toExternalForm()));
        }
    }

    private static void checkAppConfigDistFileContent(@NotNull File appConfigDistFile, @NotNull String launcherConfigDistFileContent, @NotNull Logger log) throws IOException {
        String appConfigDistFileContent;
        if (appConfigDistFile == null) {
            Run.$$$reportNull$$$0(17);
        }
        if (launcherConfigDistFileContent == null) {
            Run.$$$reportNull$$$0(18);
        }
        if (log == null) {
            Run.$$$reportNull$$$0(19);
        }
        if (!(appConfigDistFileContent = FileUtil.loadText((File)appConfigDistFile)).equals(launcherConfigDistFileContent)) {
            File appConfigDistBakFile = new File(appConfigDistFile.getAbsolutePath() + ".bak");
            FileUtil.saveText((File)appConfigDistBakFile, (String)appConfigDistFileContent);
            log.error((Object)"");
            log.error((Object)("WARNING! The \"" + UserMessageTransformer.transform((String)appConfigDistFile.getAbsolutePath()) + "\" file was changed. If you changed it manually you should change " + "the \"" + UserMessageTransformer.transform((String)StringUtil.trimSuffix((String)appConfigDistFile.getAbsolutePath(), (String)".dist")) + "\" file instead, otherwise just ignore this message. " + "The file is updated to the actual state, all changes are saved to the \"" + UserMessageTransformer.transform((String)appConfigDistBakFile.getAbsolutePath()) + "\" file."));
            log.error((Object)"");
        }
    }

    static void setConsoleCtrlCloseHandlerIfNeeded(@NotNull LauncherContextEx context, @NotNull Logger log) {
        if (context == null) {
            Run.$$$reportNull$$$0(20);
        }
        if (log == null) {
            Run.$$$reportNull$$$0(21);
        }
        if (SystemInfo.isWindows) {
            try {
                new WindowsConsoleHandler(context).setup();
            }
            catch (Throwable e) {
                ExceptionUtil.logWarning((Logger)log, (String)"Failed to setup console handler", (Throwable)e);
            }
        }
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Run.$$$reportNull$$$0(22);
        }
        if (context == null) {
            Run.$$$reportNull$$$0(23);
        }
        printer.print(NAME, "runs " + context.getAppConfig().getAppName().getName() + " in the current console, " + this.getComplexCommandUsageText());
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Run.$$$reportNull$$$0(24);
        }
        if (context == null) {
            Run.$$$reportNull$$$0(25);
        }
        this.printUsage(printer, context);
        if (context.getArguments().isJavaApplication()) {
            Run.printAdHocJvmOptionsInfo(false);
        }
    }

    protected static void printAdHocJvmOptionsInfo(boolean configure) {
        String adHocPrefix = configure ? "--J" : "-J";
        ConsoleLogger.error((String)("Use \"" + adHocPrefix + "<JVM option>\" options to specify the ad-hoc JVM options"));
        ConsoleLogger.error();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Run";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleArgs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDistFileNameSuffix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfigDistFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherConfigDistFileContent";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Run";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleArgs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareConfigDistFiles";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "prepareConfigDistFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkAppConfigDistFileContent";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleCtrlCloseHandlerIfNeeded";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

