/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.transport;

import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.transport.StateAwareSocketInputStream;
import com.jetbrains.launcher.util.TimeoutException;
import com.jetbrains.launcher.util.WaitFor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AttachedProcess
extends Process {
    @NotNull
    private final OutputStream myStdin;
    @NotNull
    private final StateAwareSocketInputStream myStdout;
    @NotNull
    private final StateAwareSocketInputStream myStderr;
    private volatile boolean myDestroyed;

    public AttachedProcess(@NotNull StateAwareSocketInputStream stdout, @NotNull StateAwareSocketInputStream stderr) {
        if (stdout == null) {
            AttachedProcess.$$$reportNull$$$0(0);
        }
        if (stderr == null) {
            AttachedProcess.$$$reportNull$$$0(1);
        }
        this.myDestroyed = false;
        this.myStdin = new FakeOutputStream();
        this.myStdout = stdout;
        this.myStderr = stderr;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.myStdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.myStdout.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.myStderr.getInputStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        try {
            new WaitFor<RuntimeException>(null){

                protected boolean condition() {
                    return AttachedProcess.this.isFinished();
                }
            };
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.doDestroy();
        return this.doGetExitValue();
    }

    @Override
    public int exitValue() {
        if (this.isFinished()) {
            return this.doGetExitValue();
        }
        throw new IllegalThreadStateException();
    }

    private int doGetExitValue() {
        return this.myDestroyed ? LauncherExitCode.INTERRUPTED.getValue() : LauncherExitCode.OK.getValue();
    }

    @Override
    public void destroy() {
        this.doDestroy();
        this.myDestroyed = true;
    }

    protected abstract void doDestroy();

    private boolean isFinished() {
        return this.myDestroyed || this.myStdout.isClosed() || this.myStderr.isClosed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "stdout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stderr";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/launcher/transport/AttachedProcess";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FakeOutputStream
    extends OutputStream {
        private FakeOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("Stream is not available");
        }
    }
}

