/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util.process;

import com.jetbrains.launcher.util.ThreadUtil;
import com.jetbrains.launcher.util.process.ProcessHandler;
import com.jetbrains.launcher.util.process.ProcessOutputLineListener;
import com.jetbrains.launcher.util.process.ProcessOutputListener;
import com.jetbrains.launcher.util.process.ProcessOutputPart;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessUtilEx {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkHasNotFailedImmediately(@NotNull Process process, @NotNull Logger log, @Nullable String logPrefix, @NotNull String tooShortRunTimeErrorMessage) {
        if (process == null) {
            ProcessUtilEx.$$$reportNull$$$0(0);
        }
        if (log == null) {
            ProcessUtilEx.$$$reportNull$$$0(1);
        }
        if (tooShortRunTimeErrorMessage == null) {
            ProcessUtilEx.$$$reportNull$$$0(2);
        }
        ProcessHandler processHandler = ProcessUtilEx.toLog(ProcessHandler.builder((Process)process), log).withPrefix(logPrefix).doNotDestroyProcessOnExit().build();
        try {
            processHandler.start();
            ProcessUtilEx.waitASecond();
        }
        finally {
            processHandler.cancel();
        }
        if (ProcessUtilEx.hasFailed(process, log)) {
            log.error((Object)tooShortRunTimeErrorMessage);
            return false;
        }
        return true;
    }

    private static void waitASecond() {
        ThreadUtil.sleep((long)1000L);
    }

    private static boolean hasFailed(@NotNull Process process, @NotNull Logger log) {
        if (process == null) {
            ProcessUtilEx.$$$reportNull$$$0(3);
        }
        if (log == null) {
            ProcessUtilEx.$$$reportNull$$$0(4);
        }
        try {
            return ProcessUtilEx.hasFailed(process.exitValue(), log);
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public static boolean hasFailed(int exitCode, @NotNull Logger log) {
        if (log == null) {
            ProcessUtilEx.$$$reportNull$$$0(5);
        }
        String message = "Process exited with code: " + exitCode;
        if (exitCode == 0) {
            log.info((Object)message);
            return false;
        }
        log.error((Object)message);
        return true;
    }

    @NotNull
    public static ProcessHandler.ProcessHandlerBuilder toLog(@NotNull ProcessHandler.ProcessHandlerPreBuilder builder, @NotNull Logger logger) {
        if (builder == null) {
            ProcessUtilEx.$$$reportNull$$$0(6);
        }
        if (logger == null) {
            ProcessUtilEx.$$$reportNull$$$0(7);
        }
        ProcessHandler.ProcessHandlerBuilder processHandlerBuilder = ProcessUtilEx.toLog(builder, logger, false);
        if (processHandlerBuilder == null) {
            ProcessUtilEx.$$$reportNull$$$0(8);
        }
        return processHandlerBuilder;
    }

    @NotNull
    public static ProcessHandler.ProcessHandlerBuilder toLog(@NotNull ProcessHandler.ProcessHandlerPreBuilder builder, final @NotNull Logger logger, final boolean debug) {
        if (builder == null) {
            ProcessUtilEx.$$$reportNull$$$0(9);
        }
        if (logger == null) {
            ProcessUtilEx.$$$reportNull$$$0(10);
        }
        ProcessHandler.ProcessHandlerBuilder processHandlerBuilder = builder.withListener((ProcessOutputListener)new ProcessOutputLineListener(32768){

            protected void outputLine(@NotNull ProcessOutputPart outputPart) {
                if (outputPart == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (debug) {
                    logger.debug((Object)ProcessUtilEx.getLogMessage(outputPart));
                } else {
                    logger.info((Object)ProcessUtilEx.getLogMessage(outputPart));
                }
            }

            protected void errorLine(@NotNull ProcessOutputPart outputPart) {
                if (outputPart == null) {
                    1.$$$reportNull$$$0(1);
                }
                logger.error((Object)ProcessUtilEx.getLogMessage(outputPart));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "outputPart";
                objectArray2[1] = "com/jetbrains/launcher/util/process/ProcessUtilEx$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLine";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLine";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (processHandlerBuilder == null) {
            ProcessUtilEx.$$$reportNull$$$0(11);
        }
        return processHandlerBuilder;
    }

    @NotNull
    private static String getLogMessage(@NotNull ProcessOutputPart outputPart) {
        if (outputPart == null) {
            ProcessUtilEx.$$$reportNull$$$0(12);
        }
        String string = (outputPart.isLineStart() ? "" : "[...]") + outputPart.getText() + (outputPart.isLineEnd() ? "" : "[...]");
        if (string == null) {
            ProcessUtilEx.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooShortRunTimeErrorMessage";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/process/ProcessUtilEx";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/process/ProcessUtilEx";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toLog";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkHasNotFailedImmediately";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasFailed";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toLog";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLogMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

