/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.errors;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.charisma.errors.ExceptionUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.util.ContentBuilder;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import webr.framework.controller.CentralManager;
import webr.framework.function.HtmlStringUtil;
import webr.framework.textBuilder.TBuilderContext;

public class TrackerBugReporter {
    public static final String LOGIN = "app_exception";
    public static final String PASSWORD = "app_exception";
    private static final String PROJECT_SHORT_NAME = "JT";
    private static final String REPORTED_ISSUE_TYPE = "Exception";
    public static final String JETBRAINS_YOUTRACK_URL = "https://youtrack.jetbrains.com/";
    private static TrackerBugReporter instance;
    protected static Log log;
    private static Pattern REGEXP_66q4da_a0a0c0g0b0d0a;

    private TrackerBugReporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReportStatus postException(Throwable throwable, String details) {
        ReportStatus status;
        String summary = ExceptionUtil.getMessage(throwable);
        String description = ExceptionUtil.stackTraceToString(throwable) + "\n" + details;
        if (throwable == null) return new ReportStatus(false, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TrackerBugReporter.Nothing_to_report", new Object[0]));
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            URIBuilder loginBuilder = new URIBuilder("https://youtrack.jetbrains.com/rest/user/login").addParameter("login", "app_exception").addParameter("password", "app_exception");
            client.execute((HttpUriRequest)new HttpPost(loginBuilder.build()));
            URIBuilder issuePutBuilder = new URIBuilder("https://youtrack.jetbrains.com/rest/issue").addParameter("project", PROJECT_SHORT_NAME).addParameter("summary", summary).addParameter("description", description).addParameter("type", REPORTED_ISSUE_TYPE).addParameter("affectedVersions", ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion());
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpPost(issuePutBuilder.build()));
            int returnCode = response.getStatusLine().getStatusCode();
            if (200 <= returnCode && returnCode < 300) {
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                status = new ReportStatus(false, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TrackerBugReporter.Can_t_parse_server_response", new Object[0]));
                Pattern _pattern_0 = REGEXP_66q4da_a0a0c0g0b0d0a;
                Matcher _matcher_0 = _pattern_0.matcher(responseBody);
                if (!_matcher_0.find()) return status;
                status = new ReportStatus(true, this.getMessage(_matcher_0.group(1)));
                return status;
            } else {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Error sending exception with answer code: " + returnCode));
                }
                status = new ReportStatus(false, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Errors.Can_t_report_an_issue", new Object[0]));
            }
            return status;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Request timed out", (Throwable)e);
                }
                status = new ReportStatus(false, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TrackerBugReporter.Server_responds_too_slow", new Object[0]));
                return status;
            } else {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't report", (Throwable)e);
                }
                status = new ReportStatus(false, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Errors.Can_t_report_an_issue", new Object[0]));
            }
            return status;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't report", (Throwable)e);
            }
            status = new ReportStatus(false, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Errors.Can_t_report_an_issue", new Object[0]));
            return status;
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getMessage(final String issueId) {
        return ContentBuilder.toString((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TBuilderContext>(){

            public void invoke(TBuilderContext builderContext) {
                builderContext.appendIndent();
                ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsgForTemplateContent("TrackerBugReporter.Thank_you_for_your_help_Issue_{issue_id}_was_reported", builderContext, new Object[]{new _FunctionTypes._void_P1_E0<TBuilderContext>(){

                    public void invoke(TBuilderContext builderContext) {
                        builderContext.append("<a href=\"");
                        builderContext.append(HtmlStringUtil.html((Object)TrackerBugReporter.JETBRAINS_YOUTRACK_URL));
                        builderContext.append("issue/");
                        builderContext.append(HtmlStringUtil.html((Object)issueId));
                        builderContext.append("\">");
                        builderContext.append(HtmlStringUtil.html((Object)issueId));
                        builderContext.append("</a>");
                    }
                }});
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public String getSystemInfo(Long thrownAt) {
        StringBuilder builder = new StringBuilder();
        builder.append('\n').append("version: ").append(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion());
        builder.append('\n').append("build: ").append(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationBuild());
        builder.append('\n').append("Thrown at: ").append(DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)thrownAt, (DateTimeZone)DateTimeZone.getDefault()), (DateTimeFormatter)DateTimeFormat.fullDateTime(), (Locale)Locale.ENGLISH));
        return builder.toString();
    }

    public String getExtendedSystemInfo(String details) {
        String[] props;
        StringBuilder builder;
        block5: {
            builder = new StringBuilder(details == null ? "" : details);
            try {
                String hostName = InetAddress.getLocalHost().getCanonicalHostName();
                builder.append('\n').append("host: ").append(hostName);
            }
            catch (UnknownHostException hostName) {
                // empty catch block
            }
            try {
                String baseUrl = (String)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"baseUrl", String.class, null);
                builder.append('\n').append("base url: ").append(baseUrl);
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can't get base url", t);
            }
        }
        for (String propName : props = new String[]{"java.version", "java.vendor", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "os.name", "os.arch", "os.version"}) {
            String propValue = System.getProperty(propName);
            if (propValue == null || propValue.length() <= 0) continue;
            builder.append('\n').append(propName).append(": ").append(propValue);
        }
        this.appendSize(builder, "Max memory: ", Runtime.getRuntime().maxMemory());
        this.appendSize(builder, "Free memory: ", Runtime.getRuntime().freeMemory());
        this.appendSize(builder, "Total memory: ", Runtime.getRuntime().totalMemory());
        builder.append('\n').append("Available processors: ").append(Runtime.getRuntime().availableProcessors());
        return builder.toString();
    }

    private void appendSize(StringBuilder builder, String fieldName, long fieldValue) {
        builder.append('\n').append(fieldName).append(FileUtils.byteCountToDisplaySize((long)fieldValue)).append(" (").append(fieldValue).append(" bytes)");
    }

    public static TrackerBugReporter get() {
        if (instance == null) {
            instance = new TrackerBugReporter();
        }
        return instance;
    }

    static {
        log = LogFactory.getLog(TrackerBugReporter.class);
        REGEXP_66q4da_a0a0c0g0b0d0a = Pattern.compile(".*id=\"([^\"]+)\".*", 0);
    }

    public static class ReportStatus {
        private boolean succeed;
        private String message;

        public ReportStatus(boolean succeed, String message) {
            this.succeed = succeed;
            this.message = message;
        }

        public boolean isSucceed() {
            return this.succeed;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

