/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.main.Limitation;
import jetbrains.charisma.main.TimeLimitation;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.DiskSpaceManagement;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.ring.license.LicenseFlag;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.youtrack.api.ring.RingAPI;
import jetbrains.youtrack.api.ring.RingConfig;
import jetbrains.youtrack.core.security.Permissions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeFieldType;

public class LicenseLimitationProvider {
    protected static Log log = LogFactory.getLog(LicenseLimitationProvider.class);

    public Collection<Limitation> getLimitations() {
        ArrayList<Limitation> limitations = new ArrayList<Limitation>();
        long licenseExpirationTime = CharismaLicenseChecker.getLicenseExpirationTime();
        Long licenseFreeUpdateEnd = CharismaLicenseChecker.getLicenseFreeUpdateEnd();
        boolean banGuestForbidden = CharismaLicenseChecker.checkFlag(LicenseFlag.BAN_GUEST_FORBIDDEN);
        limitations.add(new Limitation("user_count", this.getUserCountForLicenseCheck(), CharismaLicenseChecker.getUserCount(), Integer.MAX_VALUE));
        limitations.add(new Limitation("project_count", QueryOperations.getSize((Iterable)QueryOperations.queryGetAll((String)"Project")), CharismaLicenseChecker.getProjectCount(), Integer.MAX_VALUE));
        limitations.add(new Limitation("issue_count", QueryOperations.roughSize((Iterable)((Permissions)ServiceLocator.getBean((String)"permissions")).excludeDraftsAndDeleted(((Permissions)ServiceLocator.getBean((String)"permissions")).excludeDraftsAndDeleted((Iterable)QueryOperations.queryGetAll((String)"Issue")))), CharismaLicenseChecker.getIssueCount(), Long.MAX_VALUE));
        limitations.add(new Limitation("disk_space", CharismaLicenseChecker.getDiskSpace() == Integer.MAX_VALUE ? 0L : ((DiskSpaceManagement)ServiceLocator.getBean((String)"diskSpaceManagement")).getStorageSizeWithBackups() >> 20, CharismaLicenseChecker.getDiskSpace(), Integer.MAX_VALUE));
        if (ConfigurationUtil.isYoutrackHosted()) {
            limitations.add(new Limitation("private_projects", 0L, banGuestForbidden ? 0 : 1, 0L));
        }
        if (Long.MAX_VALUE == licenseExpirationTime) {
            limitations.add(new TimeLimitation("expiration_date", 0L, licenseExpirationTime, licenseExpirationTime));
        } else {
            if (ConfigurationUtil.isYoutrackHosted() && !this.isTrial()) {
                licenseExpirationTime -= TimeUnit.DAYS.toMillis(30L);
            }
            limitations.add(new TimeLimitation("expiration_date", 0L, licenseExpirationTime, 0L));
        }
        if (DateTimeOperations.compare((Long)licenseFreeUpdateEnd, (CompareType)CompareType.NE, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond()) && licenseFreeUpdateEnd != Long.MAX_VALUE && !ConfigurationUtil.isYoutrackHosted()) {
            limitations.add(new TimeLimitation("free_update_end", 0L, licenseFreeUpdateEnd, 0L));
        }
        limitations.add(new Limitation("change_logo_forbidden", 0L, CharismaLicenseChecker.checkFlag(LicenseFlag.CHANGE_LOGO_FORBIDDEN) ? 1 : 0, 0L));
        return limitations;
    }

    public boolean isTrial() {
        return CharismaLicenseChecker.getLicenseType_() == 2;
    }

    public int getUserCountForLicenseCheck() {
        return (Integer)_Txn.evalReadonly((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<Integer>(){

            public Integer invoke() {
                block3: {
                    if (!((RingConfig)ServiceLocator.getBean((String)"ringConfig")).hasEmbeddedHub()) {
                        try {
                            UserClient client = ((RingAPI)ServiceLocator.getBean((String)"ringApi")).getRingClient().getUserClient();
                            Filter filter = UserClient.filter();
                            filter.query("hasLicense: {" + ((RingConfig)ServiceLocator.getBean((String)"ringConfig")).getYouTrackServiceId() + "} and not is: banned");
                            Integer total = client.getUserPage((BaseFilter)filter, (FieldPartial)Partial.user((Partial.User[])new Partial.User[]{Partial.User.ID})).getTotal();
                            return total == null || total == 0 ? LicenseLimitationProvider.this.countLocalNonBannedUsers() : total;
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block3;
                            log.warn((Object)"License limitation provider can't get user count from Hub, falling back to local user count", (Throwable)e);
                        }
                    }
                }
                return LicenseLimitationProvider.this.countLocalNonBannedUsers();
            }
        });
    }

    private int countLocalNonBannedUsers() {
        return QueryOperations.getSize(UserImpl.filterBanned(UserImpl.all(), false));
    }
}

