/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.maintenance;

import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class MaintenanceUtil {
    private MaintenanceUtil() {
    }

    public static String formatMemorySize(long bytes) {
        int oneMB = 0x100000;
        return MaintenanceUtil.formatMB(bytes / (long)oneMB, bytes % (long)oneMB * 10L / (long)oneMB);
    }

    public static String formatDiskSpace(long bytes) {
        long mb = bytes >> 20;
        long oneMb = 0x100000L;
        if (mb > 1023L) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil.{0}_{1}_GB", new Object[]{mb / 1024L, mb % 1024L * 10L / 1024L});
        }
        return MaintenanceUtil.formatMB(mb, bytes % 0x100000L * 10L / 0x100000L);
    }

    public static String formatMB(long mb, long kb) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil.{0}_{1}_MB", new Object[]{mb, kb});
    }

    public static String formatFraction(double fraction) {
        long l = Math.round(fraction * 100.0);
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil.{0}_{1}{2}", new Object[]{l / 100L, l / 10L % 10L, l % 10L});
    }

    public static String formatFraction(float fraction) {
        return MaintenanceUtil.formatFraction((double)fraction);
    }

    public static String formatFractionInPercents(double fraction) {
        long l = Math.round(fraction * 10000.0);
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil.{0}_{1}{2}%", new Object[]{l / 100L, l / 10L % 10L, l % 10L});
    }

    public static String formatFractionInPercents(float fraction) {
        return MaintenanceUtil.formatFractionInPercents((double)fraction);
    }

    public static String formatFileSize(long size) {
        if (size < 1024L) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil._{0}_B", new Object[]{size});
        }
        if (1024L <= size && size < 0x100000L) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil._{0}_KB", new Object[]{size / 1024L});
        }
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil._{0}_MB", new Object[]{size / 0x100000L});
    }

    public static String formatFileSizeNoParenthesis(long size) {
        if (size < 1024L) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil.{0}_B", new Object[]{size});
        }
        if (1024L <= size && size < 0x100000L) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil.{0}_KB", new Object[]{size / 1024L});
        }
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MaintenanceUtil.{0}_MB", new Object[]{size / 0x100000L});
    }
}

