/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.misc;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.CustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.DatabaseUtils;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.persistent.IssueTagImpl;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.reports.DataExportWriter;
import jetbrains.youtrack.api.reports.ExportDataSource;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.YouTrackQueryEngine;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IssueListExportDataSource
implements ExportDataSource {
    protected static Log log = LogFactory.getLog(IssueListExportDataSource.class);
    private List<Entity> issues;
    private int counter = 0;
    private EntityIdSet visibleTags;
    private List<Entity> prototypes;
    private Map<Entity, Map<Entity, Entity>> customFieldsCache;

    public IssueListExportDataSource(Iterable<Entity> issues) {
        this.issues = Sequence.fromIterable((Iterable)QueryOperations.take(issues, (int)((Integer)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"maxExportItems", Integer.class, null)))).toListSequence();
        PersistentStoreTransaction txn = (PersistentStoreTransaction)DnqUtils.getCurrentPersistentSession();
        final PersistentEntityStoreImpl store = txn.getStore();
        final TransientStoreSession transientSession = DnqUtils.getCurrentTransientSession();
        YouTrackQueryEngine engine = (YouTrackQueryEngine)((QueryEngine)ServiceLocator.getBean((String)"queryEngine"));
        final YouTrackQueryEngine.SingleValueGetter issue2project = (YouTrackQueryEngine.SingleValueGetter)engine.getAllIssues().getOrCreateCachedInstance(txn);
        final HashSet mentionedProjects = new HashSet();
        Sequence.fromIterable(issues).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                EntityId projectId = issue2project.getValue(it.getId());
                if (projectId != null) {
                    mentionedProjects.add(transientSession.newEntity((Entity)store.getEntity(projectId)));
                }
            }
        });
        final Entity me = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        final HashMap accessToProject = new HashMap();
        this.customFieldsCache = MapSequence.fromMap(new HashMap());
        final HashSet accessiblePrototypes = new HashSet();
        for (final Entity project : SetSequence.fromSet(mentionedProjects)) {
            final HashMap fields = new HashMap();
            MapSequence.fromMap(this.customFieldsCache).put((Object)project, fields);
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)project, (String)"fields")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return IssueListExportDataSource.this.getOrPutAccessibleProjects(accessToProject, (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"readPermissionName", String.class, null), me).contains(project);
                }
            }).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity it) {
                    fields.put(AssociationSemantics.getToOne((Entity)it, (String)"prototype"), it);
                    SetSequence.fromSet((Set)accessiblePrototypes).addElement((Object)AssociationSemantics.getToOne((Entity)it, (String)"prototype"));
                }
            });
        }
        this.prototypes = Sequence.fromIterable((Iterable)QueryOperations.query(accessiblePrototypes, (String)"CustomFieldPrototype", (NodeBase)new SortByProperty(null, "ordinal", true))).toListSequence();
        this.visibleTags = DatabaseUtils.toIdSet(IssueTagImpl.applyPermissions(me, (Iterable<Entity>)QueryOperations.queryGetAll((String)"IssueTag")));
    }

    public String getFileName() {
        return "issues";
    }

    public boolean hasNextDataRow(DataExportWriter writer) {
        return this.counter < this.issues.size();
    }

    public void writeHeader(DataExportWriter writer) {
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CSVExport.Issue_Id", new Object[0]));
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CSVExport.Project", new Object[0]));
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CSVExport.Tags", new Object[0]));
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CSVExport.Summary", new Object[0]));
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.reporter", new Object[0]));
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CSVExport.Created", new Object[0]));
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CSVExport.Updated", new Object[0]));
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.states.resolved", new Object[0]));
        for (Entity prototype : ListSequence.fromList(this.prototypes)) {
            writer.writeString(((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)prototype, (String)"AbstractCustomFieldPrototype")).getNamePresentation(prototype));
        }
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CSVExport.Description", new Object[0]));
        writer.writeString(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CSVExport.Votes", new Object[0]));
    }

    public void writeDataRow(DataExportWriter writer) {
        block4: {
            Entity issue = (Entity)ListSequence.fromList(this.issues).getElement(this.counter++);
            try {
                writer.writeString(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue));
                writer.writeString((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)issue, (String)"project"), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
                writer.writeString(this.formatTags(issue));
                writer.writeString((String)PrimitiveAssociationSemantics.get((Entity)issue, (String)"summary", String.class, null));
                writer.writeString(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)issue, (String)"reporter"), (String)"User")).getVisibleName(AssociationSemantics.getToOne((Entity)issue, (String)"reporter")));
                writer.writeDate((Long)PrimitiveAssociationSemantics.get((Entity)issue, (String)"created", null));
                writer.writeDate((Long)PrimitiveAssociationSemantics.get((Entity)issue, (String)"updated", null));
                writer.writeDate((Long)PrimitiveAssociationSemantics.get((Entity)issue, (String)"resolved", null));
                for (Entity prototype : ListSequence.fromList(this.prototypes)) {
                    Entity field = this.get(AssociationSemantics.getToOne((Entity)issue, (String)"project"), prototype);
                    if (EntityOperations.equals((Entity)field, null)) {
                        writer.writeEmptyValue();
                        continue;
                    }
                    this.writeCustomFieldValue(field, issue, writer);
                }
                writer.writeString(PrimitiveAssociationSemantics.getBlobAsString((Entity)issue, (String)"description"));
                writer.writeInteger((Integer)PrimitiveAssociationSemantics.get((Entity)issue, (String)"votes", Integer.class, null));
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " can't be exported"), (Throwable)e);
            }
        }
    }

    private void writeCustomFieldValue(Entity field, Entity issue, DataExportWriter writer) {
        if (EntityOperations.equals((Entity)field, null)) {
            writer.writeEmptyValue();
        } else {
            String valueType = ((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)field, (String)"prototype"), (String)"AbstractCustomFieldPrototype")).getType(AssociationSemantics.getToOne((Entity)field, (String)"prototype")).getValueType();
            if ("instant".equals(valueType) || "dateTime".equals(valueType)) {
                writer.writeDate(IssueListExportDataSource.as_gdnns8_a0a0a0b0a0a4(((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getPrototype(field), (String)"CustomFieldPrototype")).getValue(issue, ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getPrototype(field)), Long.class));
            } else if ("int".equals(valueType)) {
                writer.writeInteger(IssueListExportDataSource.as_gdnns8_a0a0a0a1a0a0e(((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getPrototype(field), (String)"CustomFieldPrototype")).getValue(issue, ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getPrototype(field)), Integer.class));
            } else if ("Period".equals(valueType)) {
                String value = ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getRawValuePresentation(issue, field);
                if (StringUtils.isNumeric((String)value)) {
                    writer.writeInteger(Integer.valueOf(Integer.parseInt(value)));
                } else if ("?".equals(value)) {
                    writer.writeEmptyValue();
                } else {
                    writer.writeString(value);
                }
            } else if ("float".equals(valueType)) {
                writer.writeFloat(IssueListExportDataSource.as_gdnns8_a0a0a0c1a0a0e(((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getPrototype(field), (String)"CustomFieldPrototype")).getValue(issue, ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getPrototype(field)), Float.class));
            } else {
                writer.writeString(((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getRawValuePresentation(issue, field));
            }
        }
    }

    private String formatTags(Entity i) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (Entity t : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)i, (String)"tags"))) {
            if (!this.visibleTags.contains(t.getId())) continue;
            if (!first) {
                s.append(",");
            } else {
                first = false;
            }
            s.append((String)PrimitiveAssociationSemantics.get((Entity)t, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
        }
        return s.toString();
    }

    private Entity get(Entity project, Entity prototype) {
        Map m = (Map)MapSequence.fromMap(this.customFieldsCache).get((Object)project);
        if (m == null) {
            return null;
        }
        return (Entity)MapSequence.fromMap((Map)m).get((Object)prototype);
    }

    private Set<Entity> getOrPutAccessibleProjects(Map<String, Set<Entity>> accessToProject, String readPermissionName, Entity me) {
        HashSet accessibleProjects = accessToProject.get(readPermissionName);
        if (accessibleProjects == null) {
            Collection collection = ((Security)ServiceLocator.getBean((String)"security")).getProjectsUnordered(me, Enum.valueOf(Permission.class, readPermissionName), false);
            accessibleProjects = collection instanceof Set ? (HashSet)collection : new HashSet(collection);
            accessToProject.put(readPermissionName, accessibleProjects);
        }
        return accessibleProjects;
    }

    public void beforeEnd(DataExportWriter context) {
    }

    public void beforeStart(DataExportWriter context) {
    }

    private static <T> T as_gdnns8_a0a0a0b0a0a4(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_gdnns8_a0a0a0a1a0a0e(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_gdnns8_a0a0a0c1a0a0e(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }
}

