/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.notifications.mail;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.youtrack.api.notifications.MailSendListenerAdapter;
import jetbrains.youtrack.api.notifications.MailingService;
import jetbrains.youtrack.api.notifications.MessageSendListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailSendException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailingServiceImpl
implements MailingService {
    public static Log log = LogFactory.getLog(MailingServiceImpl.class);
    private JavaMailSender myMailSender;
    private SimpleMailMessage myTemplateMessage;
    private TaskExecutor myTaskExecutor;

    public void setMailSender(JavaMailSender mailSender) {
        this.myMailSender = mailSender;
    }

    public void setTemplateMessage(SimpleMailMessage templateMessage) {
        this.myTemplateMessage = templateMessage;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.myTaskExecutor = taskExecutor;
    }

    public void init() {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    public MimeMessageHelper createMimeMessageHelper() throws MessagingException {
        MimeMessageHelper helper = new MimeMessageHelper(this.myMailSender.createMimeMessage(), true, "UTF-8");
        MimeMailMessage mimeMailMessage = new MimeMailMessage(helper);
        this.myTemplateMessage.copyTo((MailMessage)mimeMailMessage);
        return helper;
    }

    public void send(MimeMessageHelper mailMessage, Map<String, String> customHeaders) {
        this.send(mailMessage, customHeaders, (MessageSendListener)new MailSendListenerAdapter());
    }

    public void send(final MimeMessageHelper messageHelper, final Map<String, String> customHeaders, final MessageSendListener mailSendListener) {
        this.myTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Address[] allRecipients;
                    MimeMessage mimeMessage = messageHelper.getMimeMessage();
                    this.removeDuplicateAddresses(mimeMessage);
                    this.addCustomHeaders(mimeMessage, customHeaders);
                    try {
                        allRecipients = mimeMessage.getAllRecipients();
                    }
                    catch (MessagingException e) {
                        throw new MailSendException("Can't get all recipients");
                    }
                    if (allRecipients == null || allRecipients.length <= 0) {
                        throw new MailSendException("Mail not sent. No recipients found.");
                    }
                    MailingServiceImpl.this.myMailSender.send(mimeMessage);
                    mailSendListener.ok(this.convert(allRecipients));
                }
                catch (MailException e) {
                    mailSendListener.error((Exception)((Object)e));
                }
            }

            private void addCustomHeaders(MimeMessage mimeMessage, Map<String, String> customHeaders2) {
                try {
                    if (customHeaders2 != null) {
                        for (IMapping entry : MapSequence.fromMap(customHeaders2)) {
                            mimeMessage.addHeader((String)entry.key(), (String)entry.value());
                        }
                    }
                }
                catch (MessagingException e) {
                    throw new MailSendException("Can't add custom headers");
                }
            }

            private void removeDuplicateAddresses(MimeMessage mimeMessage) {
                try {
                    Set<Address> toAddresses = this.getRecipients(mimeMessage, Message.RecipientType.TO);
                    Set<Address> ccAddresses = this.getRecipients(mimeMessage, Message.RecipientType.CC);
                    Set<Address> bccAddresses = this.getRecipients(mimeMessage, Message.RecipientType.BCC);
                    this.subtract(bccAddresses, toAddresses, ccAddresses);
                    this.subtract(ccAddresses, toAddresses);
                    this.setRecipients(mimeMessage, Message.RecipientType.TO, toAddresses);
                    this.setRecipients(mimeMessage, Message.RecipientType.CC, ccAddresses);
                    this.setRecipients(mimeMessage, Message.RecipientType.BCC, bccAddresses);
                }
                catch (MessagingException e) {
                    throw new MailSendException("Can't remove duplicate addresses", (Throwable)e);
                }
            }

            private String[] convert(Address[] addresses) {
                String[] converted = new String[addresses.length];
                for (int i = 0; i < addresses.length; ++i) {
                    converted[i] = addresses[i].toString();
                }
                return converted;
            }

            private Set<Address> getRecipients(MimeMessage mimeMessage, Message.RecipientType type) throws MessagingException {
                Address[] addresses = mimeMessage.getRecipients(type);
                Set<Address> addressesSet = addresses != null && addresses.length > 0 ? new HashSet<Address>(Arrays.asList(addresses)) : Collections.emptySet();
                return addressesSet;
            }

            private void setRecipients(MimeMessage mimeMessage, Message.RecipientType type, Collection<Address> addresses) throws MessagingException {
                Address[] addressArray = null;
                if (!addresses.isEmpty()) {
                    addressArray = addresses.toArray(new Address[addresses.size()]);
                }
                mimeMessage.setRecipients(type, addressArray);
            }

            private void subtract(Set<Address> fromSet, Set<Address> ... sets) {
                Iterator<Address> i = fromSet.iterator();
                block0: while (i.hasNext()) {
                    Address address = i.next();
                    for (Set<Address> set : sets) {
                        if (!set.contains(address)) continue;
                        i.remove();
                        continue block0;
                    }
                }
            }
        });
    }
}

