/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.customfields;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.event.EventMarker;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistence.customfields.RemovedCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.plugins.CustomFieldType;
import jetbrains.charisma.plugins.ICustomFieldTypeManger;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.application.RuleEngine;
import jetbrains.youtrack.api.customfields.NameValidationService;
import jetbrains.youtrack.core.security.Permission;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class CustomFieldPrototypeImpl
extends AbstractCustomFieldPrototypeImpl {
    private static String __ENTITY_TYPE__ = "CustomFieldPrototype";
    public static final String CUSTOM_FIELD_PREFIX = "__CUSTOM_FIELD__";
    public static final String RESTRICTED_CHARACTERS = ":</>";

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        ((NameValidationService)ServiceLocator.getBean((String)"nameValidationService")).checkName(entity);
    }

    public String getTypeName(Entity entity) {
        return ((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractCustomFieldPrototype")).getType(entity).getName();
    }

    public String getNameWithId(Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null) + "[" + this.getId(entity) + "]";
    }

    @Nullable
    public Entity getProjectCustomField(Entity project, Entity entity) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"ProjectCustomField", (NodeBase)new And((NodeBase)new LinkEqual("prototype", entity), (NodeBase)new LinkEqual("project", project))));
    }

    @Nullable
    public boolean isEnabledFor(Entity issue, Entity entity) {
        Entity field = QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"instances"), (String)"ProjectCustomField", (NodeBase)new LinkEqual("project", AssociationSemantics.getToOne((Entity)issue, (String)"project"))));
        if (EntityOperations.equals((Entity)field, null)) {
            return false;
        }
        return ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).isVisibleInIssue(issue, field);
    }

    public Entity findOrCreateProjectCustomField(Entity project, Entity entity) {
        return this.getType(entity).getProjectCustomField(project, entity);
    }

    public Iterable<Entity> getProjects(Entity entity) {
        return QueryOperations.selectDistinct((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"instances"), (String)"project");
    }

    public boolean isEditAccessible(Entity entity) {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"autoAttached", Boolean.class, null)).booleanValue()) {
            return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.ADMIN_UPDATE_APP, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
        }
        TreeKeepingEntityIterable usedInProjects = QueryOperations.query(((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"CustomFieldPrototype")).getProjects(entity), (String)"Project", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("archived", (Comparable)Boolean.TRUE)));
        return QueryOperations.isEmpty((Iterable)Sequence.fromIterable((Iterable)usedInProjects).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.UPDATE_PROJECT, it, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
            }
        }));
    }

    public void setValue(Entity i, Object value, Entity entity) {
        this.getType(entity).setValue(i, entity, value);
    }

    public void setValues(Entity i, Iterable<Object> values, Entity entity) {
        this.getType(entity).setValues(i, entity, values);
    }

    public void addValue(Entity i, Object value, Entity entity) {
        this.getType(entity).addValue(i, entity, value);
    }

    public void removeValue(Entity i, Object value, Entity entity) {
        this.getType(entity).removeValue(i, entity, value);
    }

    @Override
    public Object getValue(Entity i, Entity entity) {
        return this.getType(entity).getValue(i, entity);
    }

    public Iterable<Entity> filterIssues(Iterable<Entity> issues, Object value, Entity entity) {
        return this.getType(entity).filterIssues(issues, entity, value);
    }

    public void updateId(Entity entity) {
        if (PrimitiveAssociationSemantics.get((Entity)entity, (String)"id", String.class, null) == null) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"id", (Comparable)((Object)(CUSTOM_FIELD_PREFIX + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null) + "_" + ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getCustomFieldNumber((Entity)ServiceLocator.getBean((String)"applicationMetaData")))), String.class);
        }
    }

    public boolean isMultivalue(Entity entity) {
        return ((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractCustomFieldPrototype")).getType(entity).isMultiValue();
    }

    public static boolean equals(Object e, Object o) {
        Iterable iterable1;
        Iterable iterable0;
        boolean equal = false;
        equal = e instanceof Iterable || o instanceof Iterable ? (e instanceof Iterable && o instanceof Iterable ? QueryOperations.isEmpty((Iterable)QueryOperations.exclude((Iterable)(iterable0 = (Iterable)e), (Iterable)(iterable1 = (Iterable)o))) && QueryOperations.getSize((Iterable)iterable0) == QueryOperations.getSize((Iterable)iterable1) : false) : (e instanceof Entity ? EntityOperations.equals((Entity)((Entity)e), (Object)o) : ObjectUtils.equals((Object)e, (Object)o));
        return equal;
    }

    public static void clearValuesAndDelete(Entity prototype) {
        try {
            ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).addIgnoreThread();
            ((EventMarker)ServiceLocator.getBean((String)"systemApplyEventMarker")).add();
            IssueImpl.setUpdateEnabled(false);
            IssueImpl.setDuplicatesProcessingEnabled(false);
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)prototype, (String)"instances")).toListSequence().visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity it) {
                    ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).clearValuesSafe(it);
                }
            });
            CustomFieldPrototypeImpl.remove(prototype);
            DnqUtils.getCurrentTransientSession().flush();
        }
        finally {
            IssueImpl.setDuplicatesProcessingEnabled(true);
            IssueImpl.setUpdateEnabled(true);
            ((EventMarker)ServiceLocator.getBean((String)"systemApplyEventMarker")).remove();
            ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).removeIgnoreThread();
        }
    }

    public static void remove(Entity prototype) {
        RemovedCustomFieldPrototypeImpl.constructor(prototype);
        EntityOperations.remove((Entity)prototype);
    }

    public static Entity findPrototype(String name) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"CustomFieldPrototype", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
    }

    public static Entity findByNameOrLocalizedName(String name) {
        Entity prototype = CustomFieldPrototypeImpl.findPrototype(name);
        if (!EntityOperations.equals((Entity)prototype, null)) {
            return prototype;
        }
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"CustomFieldPrototype", (NodeBase)new PropertyEqual("localizedName", (Comparable)((Object)name))));
    }

    public static Entity findByImportId(String importId) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"CustomFieldPrototype", (NodeBase)new PropertyEqual("jiraId", (Comparable)((Object)importId))));
    }

    public static Entity create(String name, final String typeVisibleName) {
        CustomFieldType type = (CustomFieldType)ListSequence.fromList(((ICustomFieldTypeManger)ServiceLocator.getBean((String)"customTypesManager")).getTypes()).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<CustomFieldType>(){

            public boolean accept(CustomFieldType it) {
                return CustomFieldPrototypeImpl.eq_b55yt8_a0a0a0a0a0a0a6(it.getName(), typeVisibleName);
            }
        });
        if (type == null) {
            throw new IllegalArgumentException("No custom field type found with name " + typeVisibleName);
        }
        return type.getPrototype(name);
    }

    public static Entity findProjectCustomField(Entity project, String prototypeId) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"ProjectCustomField", (NodeBase)new And((NodeBase)new LinksEqualDecorator("prototype", (NodeBase)new PropertyEqual("id", (Comparable)((Object)prototypeId)), "CustomFieldPrototype"), (NodeBase)new LinkEqual("project", project))));
    }

    public static boolean isValidName(String fieldName) {
        return StringUtils.containsNone((String)fieldName, (String)RESTRICTED_CHARACTERS);
    }

    public static Iterable<Entity> filterFieldsAccessibleInAllProjects(Iterable<Entity> prototypes, final Iterable<Entity> projects) {
        return Sequence.fromIterable(prototypes).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(final Entity prototype) {
                return Sequence.fromIterable((Iterable)projects).all((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                    public boolean accept(Entity project) {
                        return !QueryOperations.isEmpty((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)prototype, (String)"instances"), (String)"ProjectCustomField", (NodeBase)new LinkEqual("project", project)));
                    }
                });
            }
        });
    }

    public static Entity findById(String id) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"CustomFieldPrototype", (NodeBase)new PropertyEqual("id", (Comparable)((Object)id))));
    }

    private static boolean eq_b55yt8_a0a0a0a0a0a0a6(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

