/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.security;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.persistence.security.UserRoleImpl;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.ring.license.LicenseFlag;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.ring.RingImporter;
import jetbrains.youtrack.core.security.Operation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public class UserGroupImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "UserGroup";
    public static final int ICON_MAX_WIDTH = 16;
    public static final int ICON_MAX_HEIGHT = 16;
    private static final Log securityLog = LogFactory.getLog((String)"security");

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String name, boolean allUsersGroup, boolean doNotCallGetRoot, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        if (!doNotCallGetRoot) {
            AggregationAssociationSemantics.setManyToOne((Entity)((Entity)ServiceLocator.getBean((String)"userGroupRoot")), (String)"roots", (String)"root", (Entity)entity);
        }
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)name), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"allUsersGroup", (Comparable)Boolean.valueOf(allUsersGroup), Boolean.class);
        securityLog.info((Object)((allUsersGroup ? "all users group " : "group ") + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale()) + " created"));
        return entity;
    }

    protected Entity _constructor(String name, boolean allUsersGroup, String _entityType_) {
        Entity entity = this._constructor(name, allUsersGroup, false, _entityType_);
        return entity;
    }

    protected Entity _constructor(String name, String _entityType_) {
        Entity entity = this._constructor(name, false, _entityType_);
        return entity;
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = this._constructor("New Users Group", false, _entityType_);
        return entity;
    }

    public void destructor(Entity entity) {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UserGroup.Can_t_delete_All_Users_group", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UserGroup.Can_t_delete_All_Users_group", new Object[0]), (Entity)((TransientEntity)entity)));
        }
        String description = (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"description", String.class, null);
        securityLog.info((Object)("group " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale()) + (description == null ? " deleted" : " (" + description + ") deleted")));
        super.destructor(entity);
    }

    public void addRole(Entity role, Entity project, Entity entity) {
        UserRoleImpl.createRoleForGroup(entity, role);
    }

    public Iterable<Entity> getUserRoles(Entity entity) {
        return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"parent"), null) ? AssociationSemantics.getToMany((Entity)entity, (String)"groupRoles") : QueryOperations.union((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"groupRoles"), ((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"parent"), (String)"UserGroup")).getUserRoles(AssociationSemantics.getToOne((Entity)entity, (String)"parent")));
    }

    public Iterable<Entity> getUsers(Entity entity) {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"allUsersGroup", Boolean.class, null) != false ? UserImpl.all() : AssociationSemantics.getToMany((Entity)entity, (String)"users");
    }

    public Iterable<Entity> getAdded(Entity entity) {
        return AssociationSemantics.getAddedLinks((TransientEntity)((TransientEntity)entity), (String)"users");
    }

    public Iterable<Entity> getRemoved(Entity entity) {
        return AssociationSemantics.getRemovedLinks((TransientEntity)((TransientEntity)entity), (String)"users");
    }

    public Entity getIcon(Entity entity) {
        return AssociationSemantics.getToOne((Entity)entity, (String)"icon");
    }

    public Iterable<Entity> getUsersIncludingChildrenGroups(Entity entity) {
        Iterable result = this.getUsers(entity);
        for (Entity child : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"children"))) {
            result = QueryOperations.union(result, ((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)child, (String)"UserGroup")).getUsersIncludingChildrenGroups(child));
        }
        return result;
    }

    public long getUsersCount(Entity entity) {
        return QueryOperations.getSize(this.getUsersIncludingChildrenGroups(entity));
    }

    public Iterable<Entity> getPossibleParents(Entity entity) {
        return QueryOperations.exclude((Iterable)QueryOperations.exclude((Iterable)QueryOperations.queryGetAll((String)"UserGroup"), this.getDescendants(entity)), (Iterable)QueryOperations.singleton((Entity)entity));
    }

    public Iterable<Entity> getDescendants(Entity entity) {
        Iterable res = AssociationSemantics.getToMany((Entity)entity, (String)"children");
        for (Entity child : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"children"))) {
            res = QueryOperations.union((Iterable)res, ((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)child, (String)"UserGroup")).getDescendants(child));
        }
        return res;
    }

    public Iterable<Entity> getAncestors(Entity entity) {
        return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"parent"), null) ? QueryOperations.empty((String)"UserGroup") : QueryOperations.union(((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"parent"), (String)"UserGroup")).getDescendants(AssociationSemantics.getToOne((Entity)entity, (String)"parent")), (Iterable)QueryOperations.singleton((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"parent")));
    }

    @Nullable
    public Iterable<Entity> getAncestorsOrNull(Entity entity) {
        Entity parent = AssociationSemantics.getToOne((Entity)entity, (String)"parent");
        return EntityOperations.equals((Entity)parent, null) ? null : QueryOperations.union(((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)parent, (String)"UserGroup")).getDescendants(parent), (Iterable)QueryOperations.singleton((Entity)parent));
    }

    public boolean isAccessible(Operation operation, Entity forUser, Entity entity) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)forUser, (String)"User")).hasPermission("UserGroup", operation, forUser);
    }

    static Entity constructor(String name, boolean allUsersGroup, boolean doNotCallGetRoot) {
        return ((UserGroupImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name, allUsersGroup, doNotCallGetRoot, __ENTITY_TYPE__);
    }

    private static Entity constructor(String name, boolean allUsersGroup) {
        return ((UserGroupImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name, allUsersGroup, __ENTITY_TYPE__);
    }

    public static Entity constructor(String name) {
        return ((UserGroupImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name, __ENTITY_TYPE__);
    }

    public static Entity constructor() {
        return ((UserGroupImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Entity findOrCreate(String name, Entity p, Entity role) {
        Entity group = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"UserGroup", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
        if (EntityOperations.equals((Entity)group, null)) {
            group = UserGroupImpl.createGroup(name, p, role);
        } else if (!EntityOperations.equals((Entity)p, null)) {
            ((RingImporter)ServiceLocator.getBean((String)"ringImporter")).importTeam(group, p, role);
        }
        return group;
    }

    public static Entity findOrCreate(String name) {
        return UserGroupImpl.findOrCreate(name, null, null);
    }

    private static Entity createGroup(String name, Entity p, Entity role) {
        DnqUtils.getCurrentTransientSession().flush();
        Entity group = UserGroupImpl.constructor(name);
        group = EntityOperations.equals((Entity)p, null) ? ((RingImporter)ServiceLocator.getBean((String)"ringImporter")).importGroup(group) : ((RingImporter)ServiceLocator.getBean((String)"ringImporter")).importGroup(group, p, role);
        DnqUtils.getCurrentTransientSession().flush();
        return group;
    }

    public static Entity getAllUsersGroup() {
        return (Entity)ServiceLocator.getBean((String)"allUsersGroup");
    }

    public static Entity findUserGroup(String name) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"UserGroup", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
    }

    public static String getAllUsersGroupNameInLocale() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale("youtrack.group.all_users_name", ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getLocaleData((Entity)ServiceLocator.getBean((String)"applicationMetaData")), new Object[0]);
    }

    public static String getFieldType() {
        return "UserGroup.fieldType";
    }

    public static boolean isPermittedGroupChangeAllowed() {
        return !CharismaLicenseChecker.checkFlag(LicenseFlag.BAN_GUEST_FORBIDDEN);
    }
}

