/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.security;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserRoleImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "UserRole";
    private static final Log securityLog = LogFactory.getLog((String)"security");

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(Entity user, Entity role, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        AggregationAssociationSemantics.setManyToOne((Entity)user, (String)"userRoles", (String)"user", (Entity)entity);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"role", (Entity)role);
        securityLog.info((Object)("role " + (String)PrimitiveAssociationSemantics.get((Entity)role, (String)"name", String.class, (Object)"<no role>") + " created for user " + (String)PrimitiveAssociationSemantics.get((Entity)user, (String)"login", String.class, (Object)"<no user>")));
        return entity;
    }

    protected Entity _constructor(Entity userGroup, Entity role, boolean fake, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        AggregationAssociationSemantics.setManyToOne((Entity)userGroup, (String)"groupRoles", (String)"userGroup", (Entity)entity);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"role", (Entity)role);
        securityLog.info((Object)("role " + (String)PrimitiveAssociationSemantics.get((Entity)role, (String)"name", String.class, (Object)"<no role>") + " created for user group " + (String)PrimitiveAssociationSemantics.get((Entity)userGroup, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale())));
        return entity;
    }

    public void destructor(Entity entity) {
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"user"), null)) {
            securityLog.info((Object)("role " + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"role"), (String)"name", String.class, (Object)"<no role>") + " removed from user " + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"user"), (String)"login", String.class, (Object)"<no user>")));
        } else {
            securityLog.info((Object)("role " + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"role"), (String)"name", String.class, (Object)"<no role>") + " removed from user group " + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"userGroup"), (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale())));
        }
        super.destructor(entity);
    }

    public String getVisibleName(Entity entity) {
        final StringBuilder res = new StringBuilder();
        res.append((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"role"), (String)"name", String.class, (Object)"<no role>")).append(": ");
        if (QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"projects"))) {
            res.append("All Projects");
        } else {
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"projects")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity it) {
                    res.append((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())).append("; ");
                }
            });
        }
        return res.toString();
    }

    private static Entity constructor(Entity user, Entity role) {
        return ((UserRoleImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(user, role, __ENTITY_TYPE__);
    }

    private static Entity constructor(Entity userGroup, Entity role, boolean fake) {
        return ((UserRoleImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(userGroup, role, fake, __ENTITY_TYPE__);
    }

    public static Entity createRoleForUser(Entity user, Entity role) {
        return UserRoleImpl.constructor(user, role);
    }

    public static Entity createRoleForGroup(Entity userGroup, Entity role) {
        return UserRoleImpl.constructor(userGroup, role, false);
    }

    public static Entity grantRoleToGroup(Entity r, Entity p, Entity ug) {
        return UserRoleImpl.createRoleWithCheck(r, QueryOperations.singleton((Entity)p), ((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)ug, (String)"UserGroup")).getUserRoles(ug), ug, false);
    }

    public static Entity grantRoleToUser(Entity r, Entity p, Entity u) {
        return UserRoleImpl.createRoleWithCheck(r, QueryOperations.singleton((Entity)p), AssociationSemantics.getToMany((Entity)u, (String)"userRoles"), u, true);
    }

    public static Entity createRoleWithCheck(final Entity r, Iterable<Entity> forProjects, Iterable<Entity> roles, Entity forPrincipal, boolean isUser) {
        if (QueryOperations.isEmpty((Iterable)QueryOperations.query(roles, (String)"UserRole", (NodeBase)new And((NodeBase)new LinkEqual("role", r), (NodeBase)new LinkEqual("projects", null))))) {
            ISequence roleRoles = Sequence.fromIterable(roles).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)it, (String)"role"), (Object)r) && !EntityOperations.isRemoved((Entity)it);
                }
            });
            if (QueryOperations.isEmpty(forProjects)) {
                if (!QueryOperations.isEmpty((Iterable)roleRoles)) {
                    Sequence.fromIterable((Iterable)roleRoles).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                        public void visit(Entity it) {
                            EntityOperations.remove((Entity)it);
                        }
                    });
                }
                if (isUser) {
                    return UserRoleImpl.createRoleForUser(forPrincipal, r);
                }
                return UserRoleImpl.createRoleForGroup(forPrincipal, r);
            }
            final Entity userRole = QueryOperations.isEmpty((Iterable)roleRoles) ? (isUser ? UserRoleImpl.createRoleForUser(forPrincipal, r) : UserRoleImpl.createRoleForGroup(forPrincipal, r)) : QueryOperations.getFirst((Iterable)roleRoles);
            Sequence.fromIterable(forProjects).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity __addallit__) {
                    DirectedAssociationSemantics.createToMany((Entity)userRole, (String)"projects", (Entity)__addallit__);
                }
            });
            return userRole;
        }
        return null;
    }
}

