/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Map;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.persistence.security.InternalPermissionManager;
import jetbrains.charisma.persistence.security.RoleImpl;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.security.UserGroupRootImpl;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.smartui.watchFolder.DefaultSavedQueriesProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.DefaultPermissionScheme;
import jetbrains.youtrack.core.security.DefaultRole;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSecurity
implements Security {
    protected static Log log = LogFactory.getLog(BaseSecurity.class);
    protected Entity root;
    private Entity guest;

    protected Entity doCreateRoot(String login, String password, String fullname) {
        UserGroupRootImpl.getAllUsersGroup();
        Entity root = UserImpl.constructor(login);
        PrimitiveAssociationSemantics.set((Entity)root, (String)"fullName", (Comparable)((Object)fullname), String.class);
        PrimitiveAssociationSemantics.setHashed((Entity)root, (String)"password", (String)password);
        String rootEmail = ConfigurationParameter.getParameter("root.email");
        String rootJabber = ConfigurationParameter.getParameter("root.jabber");
        if (rootEmail != null && rootEmail.length() > 0) {
            PrimitiveAssociationSemantics.set((Entity)root, (String)"email", (Comparable)((Object)rootEmail), String.class);
        }
        if (rootJabber != null && rootJabber.length() > 0) {
            PrimitiveAssociationSemantics.set((Entity)root, (String)"jabberAccountName", (Comparable)((Object)rootJabber), String.class);
        }
        ((InternalPermissionManager)ServiceLocator.getBean((String)"internalPermissionsManager")).grantPermissionsToUser(DefaultRole.SYSTEM_ADMIN.getName(), root, DefaultRole.SYSTEM_ADMIN.getPermissions(), QueryOperations.empty((String)"Project"));
        DnqUtils.getCurrentTransientSession().flush();
        ((DefaultSavedQueriesProvider)ServiceLocator.getBean((String)"savedQueriesProvider")).subscribe(root);
        ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"User")).markAsRoot(root);
        DnqUtils.getCurrentTransientSession().flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created user '" + login + "'"));
        }
        return root;
    }

    protected void createUsers(DefaultPermissionScheme dps, Map<String, DefaultPermissionScheme.PermissionGroupInfo> permissionGroups) {
        for (IMapping record : MapSequence.fromMap((Map)dps.getUsers())) {
            String userLogin = (String)record.key();
            DefaultPermissionScheme.UserInfo info = (DefaultPermissionScheme.UserInfo)record.value();
            Entity user = QueryOperations.getFirst((Iterable)QueryOperations.query(UserImpl.all(), (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)userLogin))));
            if (EntityOperations.equals((Entity)user, null)) {
                UserGroupRootImpl.getAllUsersGroup();
                user = UserImpl.constructor(userLogin);
                PrimitiveAssociationSemantics.set((Entity)user, (String)"fullName", (Comparable)((Object)info.getFullName()), String.class);
                PrimitiveAssociationSemantics.setHashed((Entity)user, (String)"password", (String)info.getPassword());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created user '" + userLogin + "'"));
                }
            }
            ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).setBanned(info.getBanned(), user);
            if (MapSequence.fromMap(permissionGroups).containsKey((Object)info.getPermissionGroup())) {
                ((InternalPermissionManager)ServiceLocator.getBean((String)"internalPermissionsManager")).grantPermissionsToUser(info.getPermissionGroup(), user, ((DefaultPermissionScheme.PermissionGroupInfo)MapSequence.fromMap(permissionGroups).get((Object)info.getPermissionGroup())).getPermissions(), QueryOperations.empty((String)"Project"));
            }
            DnqUtils.getCurrentTransientSession().flush();
        }
    }

    protected void createUserGroups(DefaultPermissionScheme dps, Map<String, DefaultPermissionScheme.PermissionGroupInfo> permissionGroups) {
        Entity allUsersGroup = UserGroupRootImpl.getAllUsersGroup();
        String allUsersGroupPermissionsGroup = dps.getAllUsersGroupPermissionGroup();
        if (MapSequence.fromMap(permissionGroups).containsKey((Object)allUsersGroupPermissionsGroup)) {
            ((InternalPermissionManager)ServiceLocator.getBean((String)"internalPermissionsManager")).grantPermissionsToGroup(allUsersGroupPermissionsGroup, allUsersGroup, ((DefaultPermissionScheme.PermissionGroupInfo)MapSequence.fromMap(permissionGroups).get((Object)allUsersGroupPermissionsGroup)).getPermissions(), QueryOperations.empty((String)"Project"));
        }
        for (IMapping record : MapSequence.fromMap((Map)dps.getUserGroups())) {
            String name = (String)record.key();
            DefaultPermissionScheme.UserGroupInfo info = (DefaultPermissionScheme.UserGroupInfo)record.value();
            Entity ug = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"UserGroup", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
            if (EntityOperations.equals((Entity)ug, null)) {
                ug = UserGroupImpl.constructor(name);
            }
            PrimitiveAssociationSemantics.set((Entity)ug, (String)"description", (Comparable)((Object)info.getDescription()), String.class);
            PrimitiveAssociationSemantics.set((Entity)ug, (String)"addNewUser", (Comparable)Boolean.valueOf(info.getAddNewUsers()), Boolean.class);
            ((InternalPermissionManager)ServiceLocator.getBean((String)"internalPermissionsManager")).grantPermissionsToGroup(info.getPermissionGroup(), ug, ((DefaultPermissionScheme.PermissionGroupInfo)MapSequence.fromMap((Map)dps.getPermissionGroups()).get((Object)info.getPermissionGroup())).getPermissions(), QueryOperations.empty((String)"Project"));
            DnqUtils.getCurrentTransientSession().flush();
        }
    }

    public void initPermissionScheme(DefaultPermissionScheme dps) {
        Map permissionGroups = dps.getPermissionGroups();
        for (IMapping record : MapSequence.fromMap((Map)permissionGroups)) {
            String roleName = (String)record.key();
            DefaultPermissionScheme.PermissionGroupInfo info = (DefaultPermissionScheme.PermissionGroupInfo)record.value();
            Entity role = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Role", (NodeBase)new PropertyEqual("name", (Comparable)((Object)roleName))));
            if (!EntityOperations.equals((Entity)role, null)) continue;
            role = RoleImpl.constructor(roleName);
            PrimitiveAssociationSemantics.setBlob((Entity)role, (String)"description", (String)info.getDescription());
            for (Permission p : Sequence.fromIterable((Iterable)info.getPermissions())) {
                DirectedAssociationSemantics.createToMany((Entity)role, (String)"permissions", (Entity)RoleImpl.toDeprecated(p));
            }
            DnqUtils.getCurrentTransientSession().flush();
        }
        this.createUsers(dps, permissionGroups);
        if (QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)UserGroupRootImpl.getAllUsersGroup(), (String)"groupRoles"))) {
            this.createUserGroups(dps, permissionGroups);
        }
    }

    public void createRoot(String login, String password, String fullname) {
        if (QueryOperations.isEmpty((Iterable)QueryOperations.query(UserImpl.all(), (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)login))))) {
            this.doCreateRoot(login, password, fullname);
        }
    }

    @NotNull
    public Entity getRoot() {
        if (EntityOperations.equals((Entity)this.root, null)) {
            _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                public void invoke() {
                    BaseSecurity.this.root = UserImpl.findRoot();
                }
            });
        }
        if (EntityOperations.equals((Entity)this.root, null)) {
            throw new IllegalStateException("root is not created");
        }
        return this.root;
    }

    public Entity getGuest() {
        if (EntityOperations.equals((Entity)this.guest, null)) {
            this.guest = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)"guest"))));
        }
        return this.guest;
    }

    public void addUserToUserGroup(Entity user, Entity group) {
        if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            UndirectedAssociationSemantics.createManyToMany((Entity)user, (String)"groups", (String)"users", (Entity)group);
        }
    }

    public void removeUserFromUserGroup(Entity user, Entity group) {
        if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            UndirectedAssociationSemantics.removeManyToMany((Entity)user, (String)"groups", (String)"users", (Entity)group);
        }
    }

    public void addGroupToParentGroup(Entity userGroup, Entity parent) {
        if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)userGroup, (String)"allUsersGroup", Boolean.class, null)).booleanValue() && !((Boolean)PrimitiveAssociationSemantics.get((Entity)parent, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            AggregationAssociationSemantics.createOneToMany((Entity)parent, (String)"children", (String)"parent", (Entity)userGroup);
        }
    }

    public void removeGroupFromParentGroup(Entity userGroup, Entity parent) {
        if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)userGroup, (String)"allUsersGroup", Boolean.class, null)).booleanValue() && !((Boolean)PrimitiveAssociationSemantics.get((Entity)parent, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            AggregationAssociationSemantics.removeOneToMany((Entity)parent, (String)"children", (String)"parent", (Entity)userGroup);
        }
    }

    public void restoreRoot(String login, String password) {
        Entity root = QueryOperations.getFirst((Iterable)Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"User")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"User")).isRoot(it);
            }
        }));
        this.ensureUserCanTakeLogin(login, root);
        DnqUtils.getCurrentTransientSession().flush();
        if (EntityOperations.equals((Entity)root, null)) {
            root = UserImpl.constructor(login);
            PrimitiveAssociationSemantics.set((Entity)root, (String)"fullName", (Comparable)((Object)login), String.class);
            ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"User")).markAsRoot(root);
        }
        this.root = root;
        PrimitiveAssociationSemantics.set((Entity)root, (String)"login", (Comparable)((Object)login), String.class);
        PrimitiveAssociationSemantics.setHashed((Entity)root, (String)"password", (String)password);
        ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"User")).setBanned(false, root);
        ((InternalPermissionManager)ServiceLocator.getBean((String)"internalPermissionsManager")).grantPermissionsToUser(DefaultRole.SYSTEM_ADMIN.getName(), root, DefaultRole.SYSTEM_ADMIN.getPermissions(), QueryOperations.empty((String)"Project"));
    }

    private void ensureUserCanTakeLogin(String login, Entity user) {
        Entity currentLoginOwner;
        if (!((String)PrimitiveAssociationSemantics.get((Entity)user, (String)"login", String.class, (Object)"<no user>")).equals(login) && !EntityOperations.equals((Entity)(currentLoginOwner = QueryOperations.getFirst((Iterable)QueryOperations.query(UserImpl.all(), (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)login))))), null)) {
            PrimitiveAssociationSemantics.set((Entity)currentLoginOwner, (String)"login", (Comparable)((Object)LoginUtils.generate((String)((String)PrimitiveAssociationSemantics.get((Entity)currentLoginOwner, (String)"login", String.class, (Object)"<no user>")))), String.class);
        }
    }

    public void waitForPermissionCacheRecalculation() {
    }
}

