/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import jetbrains.charisma.maintenance.SessionManager;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.exodus.database.IEntityListener;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityAdapter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.eventsCompat.EventsMultiplexerLegacy;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public class SessionManagerInvalidateListener {
    public SessionManagerInvalidateListener() {
        this.addListeners();
    }

    private void addListeners() {
        EventsMultiplexerLegacy.getInstance().addListener("User", (IEntityListener)new EntityAdapter<Entity>(){

            public void updatedSyncAfterConstraints(Entity old, Entity current) {
                if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)old, (String)"User")).bannedHasChanges(old)) {
                    ((SessionManager)((Object)ServiceLocator.getBean((String)"sessionManager"))).asyncInvalidateSession(current);
                }
            }

            public void removedAsync(Entity removed) {
                ((SessionManager)((Object)ServiceLocator.getBean((String)"sessionManager"))).asyncInvalidateSession(removed);
            }
        });
    }
}

