/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Set;
import jetbrains.exodus.database.IEntityListener;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityChange;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.database.TransientStoreSessionListener;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityAdapter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.eventsCompat.EventsMultiplexerLegacy;
import jetbrains.youtrack.core.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;

public class UserPermissionsCacheInvalidationListener
implements TransientStoreSessionListener,
DisposableBean {
    protected static Log log = LogFactory.getLog(UserPermissionsCacheInvalidationListener.class);
    private IEntityListener listenerProjectCustomField = null;
    private IEntityListener listenerCustomFieldPrototype = null;
    private IEntityListener rolesListener = null;
    private IEntityListener userRolesListener = null;
    private IEntityListener usersListener = null;
    private IEntityListener userGroupsListener = null;
    private IEntityListener projectsListener = null;

    public void flushed(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> set) {
        ((Security)ServiceLocator.getBean((String)"security")).checkValid();
    }

    public void afterConstraintsFail(@NotNull TransientStoreSession session, @NotNull Set<DataIntegrityViolationException> set) {
    }

    @Deprecated
    public void beforeFlushAfterConstraints(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> set) {
    }

    public void beforeFlushBeforeConstraints(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> set) {
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding listeners to invalidate cached user permissions to project custom fields");
        }
        this.listenerProjectCustomField = new EntityAdapter<Entity>(){

            public void addedSyncAfterConstraints(Entity added) {
                UserPermissionsCacheInvalidationListener.this.invalidate();
            }

            public void removedSyncAfterConstraints(Entity removed) {
                UserPermissionsCacheInvalidationListener.this.invalidate();
            }

            public void updatedSyncAfterConstraints(Entity old, Entity current) {
                UserPermissionsCacheInvalidationListener.this.invalidate();
            }
        };
        this.listenerCustomFieldPrototype = new EntityAdapter<Entity>(){

            public void updatedSyncAfterConstraints(Entity old, Entity current) {
                UserPermissionsCacheInvalidationListener.this.invalidate();
            }
        };
        this.rolesListener = new EntityAdapter<Entity>(){

            public void updatedSyncAfterConstraints(Entity old, Entity current) {
                if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)old), (String)"permissions")) {
                    UserPermissionsCacheInvalidationListener.this.invalidate();
                }
            }
        };
        this.userRolesListener = new EntityAdapter<Entity>(){

            public void updatedSyncAfterConstraints(Entity old, Entity current) {
                UserPermissionsCacheInvalidationListener.this.invalidate();
            }
        };
        this.usersListener = new EntityAdapter<Entity>(){

            public void addedSyncAfterConstraints(Entity added) {
                UserPermissionsCacheInvalidationListener.this.invalidate();
            }

            public void updatedSyncAfterConstraints(Entity old, Entity current) {
                if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)old), (String)"groups") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)old), (String)"userRoles")) {
                    UserPermissionsCacheInvalidationListener.this.invalidate();
                }
            }
        };
        this.userGroupsListener = new EntityAdapter<Entity>(){

            public void updatedSyncAfterConstraints(Entity old, Entity current) {
                if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)old), (String)"groupRoles")) {
                    UserPermissionsCacheInvalidationListener.this.invalidate();
                }
            }
        };
        this.projectsListener = new EntityAdapter<Entity>(){

            public void removedSyncAfterConstraints(Entity removed) {
                UserPermissionsCacheInvalidationListener.this.invalidate();
            }

            public void updatedSyncAfterConstraints(Entity old, Entity current) {
                if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)old), (String)"needsToContinueImport") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)old), (String)"archived") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)old), (String)"name")) {
                    UserPermissionsCacheInvalidationListener.this.invalidate();
                }
            }

            public void addedSyncAfterConstraints(Entity added) {
                UserPermissionsCacheInvalidationListener.this.invalidate();
            }
        };
        EventsMultiplexerLegacy.getInstance().addListener("ProjectCustomField", this.listenerProjectCustomField);
        EventsMultiplexerLegacy.getInstance().addListener("CustomFieldPrototype", this.listenerCustomFieldPrototype);
        EventsMultiplexerLegacy.getInstance().addListener("Role", this.rolesListener);
        EventsMultiplexerLegacy.getInstance().addListener("UserRole", this.userRolesListener);
        EventsMultiplexerLegacy.getInstance().addListener("User", this.usersListener);
        EventsMultiplexerLegacy.getInstance().addListener("UserGroup", this.userGroupsListener);
        EventsMultiplexerLegacy.getInstance().addListener("Project", this.projectsListener);
    }

    public void destroy() throws Exception {
        EventsMultiplexerLegacy.removeListenerSafe((String)"Project", (IEntityListener)this.projectsListener);
        EventsMultiplexerLegacy.removeListenerSafe((String)"UserGroup", (IEntityListener)this.userGroupsListener);
        EventsMultiplexerLegacy.removeListenerSafe((String)"User", (IEntityListener)this.usersListener);
        EventsMultiplexerLegacy.removeListenerSafe((String)"UserRole", (IEntityListener)this.userRolesListener);
        EventsMultiplexerLegacy.removeListenerSafe((String)"Role", (IEntityListener)this.rolesListener);
        EventsMultiplexerLegacy.removeListenerSafe((String)"CustomFieldPrototype", (IEntityListener)this.listenerCustomFieldPrototype);
        EventsMultiplexerLegacy.removeListenerSafe((String)"ProjectCustomField", (IEntityListener)this.listenerProjectCustomField);
    }

    private void invalidate() {
        ((Security)ServiceLocator.getBean((String)"security")).invalidate();
    }
}

