/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Set;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.service.UserFields;
import jetbrains.charisma.service.UserProfileService;
import jetbrains.exodus.database.EntityChangeType;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityChange;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.database.TransientStoreSessionListener;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.application.RuleEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoWatchIssueListener
implements TransientStoreSessionListener {
    private static final Object IGNORE_FLAG = new Object();
    private final ThreadLocal<Object> ignoreThreads = new ThreadLocal();
    private final ThreadLocal<TransientStoreSession> threadCurrentSession = new ThreadLocal();

    @Deprecated
    public void beforeFlushAfterConstraints(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> set) {
        this.threadCurrentSession.remove();
    }

    public void afterConstraintsFail(@NotNull TransientStoreSession session, @NotNull Set<DataIntegrityViolationException> set) {
        this.threadCurrentSession.remove();
    }

    public void beforeFlushBeforeConstraints(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> changes) {
        if (this.isAutowatchDisabled()) {
            return;
        }
        if (this.threadCurrentSession.get() == session) {
            return;
        }
        try {
            this.threadCurrentSession.set(session);
            for (TransientEntityChange change : changes) {
                if (change.getChangeType().equals((Object)EntityChangeType.REMOVE)) continue;
                TransientEntity entity = change.getTransientEntity();
                if (DnqUtils._instanceOf((Object)entity, (String)"Issue")) {
                    if (change.getChangeType().equals((Object)EntityChangeType.ADD)) continue;
                    Entity issue = DnqUtils.cast((Object)entity, (String)"Issue");
                    if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isDraft(issue)) {
                        return;
                    }
                    if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)issue), (String[])new String[]{"voters"}) && !QueryOperations.isEmpty((Iterable)AssociationSemantics.getAddedLinks((TransientEntity)((TransientEntity)DnqUtils.cast((Object)change.getSnapshotEntity(), (String)"Issue")), (String)"voters"))) {
                        this.watchIssueOnVotesChange(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), issue);
                    }
                    if (!EntityOperations.hasChanges((TransientEntity)((TransientEntity)issue), (String[])new String[]{"updated"})) continue;
                    this.watchIssueOnUpdate(AssociationSemantics.getToOne((Entity)issue, (String)"updatedBy"), issue);
                    continue;
                }
                if (!DnqUtils._instanceOf((Object)entity, (String)"IssueComment") || !change.getChangeType().equals((Object)EntityChangeType.ADD)) continue;
                Entity comment = DnqUtils.cast((Object)entity, (String)"IssueComment");
                if (!change.getChangeType().equals((Object)EntityChangeType.ADD)) continue;
                this.watchIssueOnNewCommenrt(AssociationSemantics.getToOne((Entity)comment, (String)"author"), AssociationSemantics.getToOne((Entity)comment, (String)"issue"));
            }
        }
        catch (RuntimeException exception) {
            this.threadCurrentSession.remove();
            throw exception;
        }
    }

    private void watchIssueOnVotesChange(Entity watcher, Entity i) {
        if (((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getNotificationsProfile(watcher).isAutoWatchOnVote()) {
            this.watch(watcher, i);
        }
    }

    private void watchIssueOnUpdate(Entity updater, Entity i) {
        if (((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getNotificationsProfile(updater).isAutoWatchOnUpdate()) {
            this.watch(updater, i);
        }
    }

    private void watchIssueOnNewCommenrt(Entity updater, Entity i) {
        if (((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getNotificationsProfile(updater).isAutoWatchOnComment()) {
            this.watch(updater, i);
        }
    }

    private void watch(Entity updater, Entity issue) {
        if (!EntityOperations.equals((Entity)updater, (Object)AssociationSemantics.getToOne((Entity)issue, (String)"reporter")) && !QueryOperations.contains(((UserFields)ServiceLocator.getBean((String)"userFields")).getIssueAssignees(issue), (Entity)updater)) {
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).watch(updater, issue);
        }
    }

    public void flushed(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> set) {
    }

    private boolean isAutowatchDisabled() {
        return ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).isIgnoreThread() || this.isIgnoreThread();
    }

    private boolean isIgnoreThread() {
        return this.ignoreThreads.get() == IGNORE_FLAG;
    }

    public void addIgnoreThread() {
        this.ignoreThreads.set(IGNORE_FLAG);
    }

    public void removeIgnoreThread() {
        this.ignoreThreads.remove();
    }
}

