/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import java.util.Iterator;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public class ConstraintsErrorMessageUtil {
    protected ConstraintsErrorMessageUtil() {
    }

    public static String createReportAboutIssues(String linkDescription, Iterable<Entity> issues, boolean hasMore) {
        _FunctionTypes._return_P1_E0<Entity, Entity> getIssue = new _FunctionTypes._return_P1_E0<Entity, Entity>(){

            public Entity invoke(Entity entity) {
                return DnqUtils.cast((Object)entity, (String)"Issue");
            }
        };
        return ConstraintsErrorMessageUtil.createAdjustableReportAboutIssues(linkDescription, (_FunctionTypes._return_P1_E0<? extends Entity, ? super Entity>)getIssue, issues, hasMore);
    }

    public static String createReportAboutComments(String linkDescription, Iterable<Entity> comments, boolean hasMore) {
        _FunctionTypes._return_P1_E0<Entity, Entity> getIssue = new _FunctionTypes._return_P1_E0<Entity, Entity>(){

            public Entity invoke(Entity entity) {
                if (DnqUtils._instanceOf((Object)entity, (String)"DraftComment")) {
                    return AssociationSemantics.getToOne((Entity)DnqUtils.cast((Object)entity, (String)"DraftComment"), (String)"issue");
                }
                return AssociationSemantics.getToOne((Entity)DnqUtils.cast((Object)entity, (String)"IssueComment"), (String)"issue");
            }
        };
        return ConstraintsErrorMessageUtil.createAdjustableReportAboutIssues(linkDescription, (_FunctionTypes._return_P1_E0<? extends Entity, ? super Entity>)getIssue, comments, hasMore);
    }

    public static String createReportAboutAttachments(String linkDescription, Iterable<Entity> attachments, boolean hasMore) {
        _FunctionTypes._return_P1_E0<Entity, Entity> getIssue = new _FunctionTypes._return_P1_E0<Entity, Entity>(){

            public Entity invoke(Entity entity) {
                Entity attachment = DnqUtils.cast((Object)entity, (String)"IssueAttachment");
                return AssociationSemantics.getToOne((Entity)attachment, (String)"issue");
            }
        };
        return ConstraintsErrorMessageUtil.createAdjustableReportAboutIssues(linkDescription, (_FunctionTypes._return_P1_E0<? extends Entity, ? super Entity>)getIssue, attachments, hasMore);
    }

    protected static String createAdjustableReportAboutIssues(String linkDescrition, _FunctionTypes._return_P1_E0<? extends Entity, ? super Entity> getIssue, Iterable<Entity> entities, boolean hasMore) {
        StringBuilder sb = new StringBuilder();
        Iterator<Entity> it = entities.iterator();
        int count = 0;
        while (it.hasNext()) {
            Entity issue = (Entity)getIssue.invoke((Object)it.next());
            sb.append(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue));
            ++count;
            if (!it.hasNext()) continue;
            sb.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConstraintsErrorMessageUtil.comma_separator", new Object[0])).append(' ');
        }
        if (count > 1 || hasMore) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConstraintsErrorMessageUtil.{link_description}_{issues_list}{__conditional__and_more}_issues", new Object[]{linkDescrition, sb, hasMore, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConstraintsErrorMessageUtil._and_more", new Object[0])});
        }
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConstraintsErrorMessageUtil.{link_description}_{issue_id}_issue", new Object[]{linkDescrition, sb});
    }
}

