/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.dao.api.Listener;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.application.AppLifecycleListenerAdapter;
import jetbrains.youtrack.api.ring.RingAPI;
import jetbrains.youtrack.api.ring.RingConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HubServiceAllowedOriginsProvider
extends AppLifecycleListenerAdapter {
    protected static Log log = LogFactory.getLog(HubServiceAllowedOriginsProvider.class);
    private volatile Set<String> origins = new HashSet<String>();
    private Listener serviceListener = new Listener(){

        public void added(Event event) {
            HubServiceAllowedOriginsProvider.this.calculateHubServiceOrigins();
        }

        public void removed(Event event) {
            HubServiceAllowedOriginsProvider.this.calculateHubServiceOrigins();
        }

        public void updated(Event event) {
            HubServiceAllowedOriginsProvider.this.calculateHubServiceOrigins();
        }
    };

    public Set<String> getTrustedHubServiceOrigins() {
        return this.origins;
    }

    public void start() {
        block3: {
            try {
                this.calculateHubServiceOrigins();
                if (((RingConfig)ServiceLocator.getBean((String)"ringConfig")).isEnabled() && !((RingConfig)ServiceLocator.getBean((String)"ringConfig")).hasEmbeddedHub()) {
                    ((RingAPI)ServiceLocator.getBean((String)"ringApi")).getServiceDAO().addListener(this.serviceListener);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"", (Throwable)e);
            }
        }
    }

    public void stop() {
        super.stop();
        if (((RingConfig)ServiceLocator.getBean((String)"ringConfig")).isEnabled() && !((RingConfig)ServiceLocator.getBean((String)"ringConfig")).hasEmbeddedHub()) {
            ((RingAPI)ServiceLocator.getBean((String)"ringApi")).getServiceDAO().removeListener(this.serviceListener);
        }
    }

    private synchronized void calculateHubServiceOrigins() {
        block6: {
            HashSet<String> serviceOrigins = new HashSet<String>();
            try {
                if (((RingConfig)ServiceLocator.getBean((String)"ringConfig")).isEnabled() && !((RingConfig)ServiceLocator.getBean((String)"ringConfig")).hasEmbeddedHub()) {
                    for (Service service : ((RingAPI)ServiceLocator.getBean((String)"ringApi")).getServiceDAO().getAllItems()) {
                        if (!service.isTrusted().booleanValue()) continue;
                        if (service.getHomeUrl() != null) {
                            serviceOrigins.add(this.getOrigin(service.getHomeUrl()));
                        }
                        for (String redirectUri : service.getRedirectUris()) {
                            if (redirectUri == null || !redirectUri.startsWith("http")) continue;
                            serviceOrigins.add(this.getOrigin(redirectUri));
                        }
                    }
                }
                this.origins = serviceOrigins;
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)"Can't calculate allowed origins from Hub service data", (Throwable)e);
            }
        }
    }

    private String getOrigin(String homeUrl) {
        try {
            return new URL(homeUrl).getAuthority();
        }
        catch (MalformedURLException ex) {
            return homeUrl;
        }
    }
}

