/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueTagOrderedIssuesProvider;
import jetbrains.charisma.persistent.OrderedIssuesProvider;
import jetbrains.charisma.persistent.ProjectOrderedIssuesProvider;
import jetbrains.charisma.persistent.SavedQueryOrderedIssuesProvider;
import jetbrains.charisma.persistent.StringUtils;
import jetbrains.charisma.service.UserProfileService;
import jetbrains.charisma.smartui.watchFolder.SpecialFolders;
import jetbrains.charisma.smartui.watchFolder.WatchFolderImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueFolderUtil {
    protected static Log log = LogFactory.getLog(IssueFolderUtil.class);

    @NotNull
    public static Iterable<Entity> findByIds(Iterable<String> ids) {
        final Wrappers._T result = new Wrappers._T((Object)QueryOperations.empty((String)"IssueFolder"));
        if (ids != null) {
            Sequence.fromIterable(ids).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<String>(){

                public void visit(String it) {
                    block3: {
                        try {
                            Entity folder = IssueFolderUtil.findById(it);
                            if (!EntityOperations.equals((Entity)folder, null)) {
                                result.value = QueryOperations.union((Iterable)((Iterable)result.value), (Iterable)QueryOperations.singleton((Entity)folder));
                            }
                        }
                        catch (Throwable e) {
                            if (!log.isErrorEnabled()) break block3;
                            log.error((Object)("Cannot find issue folder by id " + it), e);
                        }
                    }
                }
            });
        }
        return (Iterable)result.value;
    }

    @Nullable
    public static Entity findById(@Nullable String fqFolderId) {
        if (fqFolderId == null || fqFolderId.length() == 0) {
            return null;
        }
        if (IssueFolderUtil.isTag(fqFolderId = fqFolderId.toLowerCase())) {
            return WatchFolderImpl.fromId("IssueTag", StringUtils.substring(fqFolderId, "$t$".length() + 1));
        }
        if (IssueFolderUtil.isSavedQuery(fqFolderId)) {
            return WatchFolderImpl.fromId("SavedQuery", StringUtils.substring(fqFolderId, "$s$".length() + 1));
        }
        return ProjectImpl.findReadableProject((String)fqFolderId, (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
    }

    private static boolean isSavedQuery(String fqFolderId) {
        return fqFolderId.startsWith("$s$-");
    }

    private static boolean isTag(String fqFolderId) {
        return fqFolderId.startsWith("$t$-");
    }

    @Nullable
    public static OrderedIssuesProvider getOrderedIssuesProvider(Entity folder) {
        String fqFolderId = SpecialFolders.getFqFolderId(folder);
        if (fqFolderId == null || fqFolderId.length() == 0) {
            return null;
        }
        if (IssueFolderUtil.isTag(fqFolderId = fqFolderId.toLowerCase())) {
            return new IssueTagOrderedIssuesProvider(DnqUtils.cast((Object)folder, (String)"IssueTag"));
        }
        if (IssueFolderUtil.isSavedQuery(fqFolderId)) {
            return new SavedQueryOrderedIssuesProvider(DnqUtils.cast((Object)folder, (String)"SavedQuery"));
        }
        return new ProjectOrderedIssuesProvider(DnqUtils.cast((Object)folder, (String)"Project"));
    }

    public static Entity getContextFolder(Entity currentCtxFolder, String projectName, String query) {
        Entity project;
        if (!EntityOperations.equals((Entity)currentCtxFolder, null)) {
            return currentCtxFolder;
        }
        if (projectName != null && projectName.length() > 0 && !EntityOperations.equals((Entity)(project = ProjectImpl.findReadableProject((String)projectName, (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())), null)) {
            return project;
        }
        if (query != null && query.length() > 0) {
            return null;
        }
        return ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getGeneralUserProfile(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()).getFilterFolder();
    }
}

