/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.exodus.core.dataStructures.ObjectCache;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public class IssueIdCache {
    private final ReentrantLock rwLock = new ReentrantLock();
    private final ObjectCache<String, EntityId> cache;

    public IssueIdCache(int cacheSize) {
        this.cache = new ObjectCache(cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity fromId(String id) {
        EntityId resultId;
        Entity result = null;
        try {
            this.rwLock.lock();
            resultId = (EntityId)this.cache.tryKey((Object)id);
        }
        finally {
            this.rwLock.unlock();
        }
        if (resultId != null) {
            Entity entity = ((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getEntity(resultId);
            if (!EntityOperations.isRemoved((Entity)entity)) {
                entity = DnqUtils.getCurrentTransientSession().getEntity(resultId);
                if (!EntityOperations.isRemoved((Entity)entity) && !((Boolean)PrimitiveAssociationSemantics.get((Entity)DnqUtils.cast((Object)entity, (String)"Issue"), (String)"deleted", Boolean.class, null)).booleanValue()) {
                    result = DnqUtils.cast((Object)entity, (String)"Issue");
                } else {
                    this.removeIssueFromCache(id);
                }
            } else {
                this.removeIssueFromCache(id);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity fromProjectAndId(long numberInProject, Entity project, String id) {
        Entity result = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new And((NodeBase)new And((NodeBase)new LinkEqual("project", project), (NodeBase)new PropertyEqual("numberInProject", (Comparable)Long.valueOf(numberInProject))), (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("deleted", (Comparable)Boolean.TRUE)))));
        if (EntityOperations.equals((Entity)result, null)) {
            result = this.fromProjectTrace(numberInProject, project);
        }
        if (!EntityOperations.equals((Entity)result, null)) {
            try {
                this.rwLock.lock();
                if (this.cache.getObject((Object)id) == null) {
                    this.cache.cacheObject((Object)id, (Object)result.getId());
                }
            }
            finally {
                this.rwLock.unlock();
            }
        }
        return result;
    }

    public void clear() {
        try {
            this.rwLock.lock();
            this.cache.clear();
        }
        finally {
            this.rwLock.unlock();
        }
    }

    private Entity fromProjectTrace(long numberInProject, Entity project) {
        Entity key = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"IssueKey", (NodeBase)new And((NodeBase)new LinkEqual("project", project), (NodeBase)new PropertyEqual("numberInProject", (Comparable)Long.valueOf(numberInProject)))));
        if (!EntityOperations.equals((Entity)key, null)) {
            return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new And((NodeBase)new LinkEqual("projectTrace", key), (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("deleted", (Comparable)Boolean.TRUE)))));
        }
        return null;
    }

    private void removeIssueFromCache(String id) {
        try {
            this.rwLock.lock();
            this.cache.remove((Object)id);
        }
        finally {
            this.rwLock.unlock();
        }
    }
}

