/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.persistent.AllowedOriginImpl;
import jetbrains.charisma.persistent.HubServiceAllowedOriginsProvider;
import jetbrains.exodus.database.IEntityListener;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityAdapter;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.runtime.listeners.EventsMultiplexerProxy;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.jetbrains.annotations.NotNull;

public class RestSettings {
    private final IEntityListener<Entity> listener;
    private volatile List<String> origins = Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)((Entity)ServiceLocator.getBean((String)"originsSettings")), (String)"allowedOrigins")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

        public String select(Entity it) {
            return RestSettings.this.getOrigin((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"origin", String.class, null));
        }
    }).toListSequence();

    public RestSettings() {
        this.listener = new EntityAdapter<Entity>(){

            public void updatedSync(@NotNull Entity prev, @NotNull Entity current) {
                if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)prev), (String)"allowedOrigins")) {
                    RestSettings.this.origins = (List)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)current, (String)"allowedOrigins")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

                        public String select(Entity it) {
                            return RestSettings.this.getOrigin((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"origin", String.class, null));
                        }
                    }).toListSequence();
                }
            }
        };
        ((EventsMultiplexerProxy)ServiceLocator.getBean((String)"eventsMultiplexerProxy")).addListener("AllowedOriginsSettings", this.listener);
    }

    public boolean isAllowAllOrigins() {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"originsSettings")), (String)"allowAllOrigins", Boolean.class, null);
    }

    public void setAllowAllOrigins(boolean allow) {
        PrimitiveAssociationSemantics.set((Entity)((Entity)ServiceLocator.getBean((String)"originsSettings")), (String)"allowAllOrigins", (Comparable)Boolean.valueOf(allow), Boolean.class);
    }

    public Set<String> getAllAllowedOrigins() {
        if (this.isAllowAllOrigins()) {
            return null;
        }
        Set<String> serviceUrls = ((HubServiceAllowedOriginsProvider)((Object)ServiceLocator.getBean((String)"hubServiceAllowedOriginsProvider"))).getTrustedHubServiceOrigins();
        serviceUrls.addAll(this.origins);
        return serviceUrls;
    }

    public Set<String> getTrustedHubServiceOrigins() {
        return ((HubServiceAllowedOriginsProvider)((Object)ServiceLocator.getBean((String)"hubServiceAllowedOriginsProvider"))).getTrustedHubServiceOrigins();
    }

    private String getOrigin(String homeUrl) {
        try {
            return new URL(homeUrl).getAuthority();
        }
        catch (MalformedURLException ex) {
            return homeUrl;
        }
    }

    public void setAllowedOrigins(Iterable<String> origins) {
        ISetSequence allowedOrigins = SetSequence.fromSetWithValues(new HashSet(), origins);
        for (Object origin : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)((Entity)ServiceLocator.getBean((String)"originsSettings")), (String)"allowedOrigins"))) {
            if (SetSequence.fromSet((Set)allowedOrigins).contains(PrimitiveAssociationSemantics.get((Entity)origin, (String)"origin", String.class, null))) {
                SetSequence.fromSet((Set)allowedOrigins).removeElement(PrimitiveAssociationSemantics.get((Entity)origin, (String)"origin", String.class, null));
                continue;
            }
            EntityOperations.remove((Entity)origin);
        }
        for (Object origin : SetSequence.fromSet((Set)allowedOrigins)) {
            AggregationAssociationSemantics.createOneToMany((Entity)((Entity)ServiceLocator.getBean((String)"originsSettings")), (String)"allowedOrigins", (String)"settings", (Entity)AllowedOriginImpl.constructor((String)origin));
        }
    }

    public Set<String> getAllowedOriginNames() {
        return SetSequence.fromSetWithValues(new HashSet(), (Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)((Entity)ServiceLocator.getBean((String)"originsSettings")), (String)"allowedOrigins")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

            public String select(Entity it) {
                return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"origin", String.class, null);
            }
        }));
    }

    public void close() {
        ((EventsMultiplexerProxy)ServiceLocator.getBean((String)"eventsMultiplexerProxy")).removeListener("AllowedOriginsSettings", this.listener);
    }
}

