/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.plugins;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.youtrack.api.application.AppLifecycleListener;
import jetbrains.youtrack.api.application.AppLifecycleListenerWithDeps;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppLifecycleListeners {
    protected static Log log = LogFactory.getLog(AppLifecycleListeners.class);
    private Set<AppLifecycleListener> inited = SetSequence.fromSet(new HashSet());
    private List<AppLifecycleListener> myListeners;

    public void start() {
        ISetSequence entered = SetSequence.fromSet(new HashSet());
        ISetSequence processed = SetSequence.fromSet(new HashSet());
        for (final AppLifecycleListener l : ListSequence.fromList(this.getListeners())) {
            _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0((Set)entered, (Set)processed){
                final /* synthetic */ Set val$entered;
                final /* synthetic */ Set val$processed;
                {
                    this.val$entered = set;
                    this.val$processed = set2;
                }

                public void invoke() {
                    AppLifecycleListeners.this.visit(l, this.val$entered, this.val$processed);
                }
            });
        }
    }

    public void stop() {
        for (final AppLifecycleListener listener : SetSequence.fromSet(this.inited)) {
            try {
                _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                    public void invoke() {
                        listener.stop();
                    }
                });
            }
            catch (Throwable e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("Failed to stop app lifecycle listener " + listener.getClass().getName()), e);
            }
        }
    }

    private void visit(AppLifecycleListener listener, Set<AppLifecycleListener> entered, Set<AppLifecycleListener> processed) {
        if (SetSequence.fromSet(processed).contains((Object)listener)) {
            return;
        }
        if (SetSequence.fromSet(entered).contains((Object)listener)) {
            throw new IllegalStateException("Dependency cycle detected for listener " + listener.getClass().getSimpleName());
        }
        SetSequence.fromSet(entered).addElement((Object)listener);
        if (listener instanceof AppLifecycleListenerWithDeps) {
            for (AppLifecycleListener dep : ((AppLifecycleListenerWithDeps)listener).getDependencies()) {
                this.visit(dep, entered, processed);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Start " + listener.getClass().getSimpleName()));
        }
        SetSequence.fromSet(this.inited).addElement((Object)listener);
        listener.start();
        SetSequence.fromSet(processed).addElement((Object)listener);
    }

    public List<AppLifecycleListener> getListeners() {
        return this.myListeners;
    }

    public void setListeners(List<AppLifecycleListener> value) {
        this.myListeners = value;
    }
}

