/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.plugins;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.errors.IssueAwareReadonlyTransactionException;
import jetbrains.charisma.misc.Message;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.CustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.plugins.CustomFieldType;
import jetbrains.charisma.smartui.executor.ComponentCallback;
import jetbrains.exodus.database.exceptions.EntityRemovedException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.customfields.DetalizationLevel;
import jetbrains.youtrack.api.customfields.FieldValueRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class CustomFieldWrapper<T extends Entity, V> {
    protected T field;
    protected String name;
    private String namePresenatation;
    protected Entity issue;
    protected FieldValueRenderer<V> valueRenderer;
    protected CustomFieldType type;

    protected CustomFieldWrapper(Entity issue, T field, CustomFieldType type) {
        this.field = field;
        this.issue = issue;
        this.type = type;
        this.valueRenderer = ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getValueRenderer((Entity)this.field);
        Entity prototype = ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(field, (String)"ProjectCustomField")).getPrototype((Entity)field);
        this.name = StringInterner.intern((String)((String)PrimitiveAssociationSemantics.get((Entity)prototype, (String)"name", String.class, null)));
        this.namePresenatation = (String)PrimitiveAssociationSemantics.get((Entity)prototype, (String)"localizedName", String.class, null);
        this.namePresenatation = this.namePresenatation == null || this.namePresenatation.length() == 0 ? this.name : StringInterner.intern((String)this.namePresenatation);
    }

    protected V getFieldValue() {
        try {
            return this.type.getValue(this.getIssue(), ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field));
        }
        catch (EntityRemovedException e) {
            return null;
        }
        catch (EntityRemovedInDatabaseException e) {
            return null;
        }
    }

    protected void setFieldValue(V value) {
        if (EntityOperations.isRemoved(this.field) || !this.verifyTypeAndNotificateFail(this.issue)) {
            return;
        }
        Object v = ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field), (String)"CustomFieldPrototype")).getValue(this.getIssue(), ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field));
        try {
            if (value != null) {
                ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field), (String)"CustomFieldPrototype")).setValue(this.getIssue(), value, ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field));
            } else if (v != null) {
                ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field), (String)"CustomFieldPrototype")).setValue(this.getIssue(), null, ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field));
            }
        }
        catch (ReadonlyTransactionException e) {
            throw new IssueAwareReadonlyTransactionException(this.getIssue(), e);
        }
    }

    public final String getPresentation() {
        V v = this.getFieldValue();
        if (this.showMandatoryFieldText(v)) {
            return CustomFieldWrapper.getSetValueMessage();
        }
        return StringInterner.intern((String)this.getValueRenderer().getPresentation(v, DetalizationLevel.BASIC));
    }

    public final String getFullPresentation() {
        V v = this.getFieldValue();
        if (this.showMandatoryFieldText(v)) {
            return CustomFieldWrapper.getSetValueMessage();
        }
        return StringInterner.intern((String)this.getValueRenderer().getPresentation(v, DetalizationLevel.FULL));
    }

    public final String getString() {
        return StringInterner.intern((String)this.getValueRenderer().getPresentation(this.getFieldValue(), DetalizationLevel.PRIMITIVE));
    }

    @Nullable
    public String getEmptyElementText() {
        return (Boolean)PrimitiveAssociationSemantics.get(this.field, (String)"canBeEmpty", Boolean.class, null) != false ? StringInterner.intern((String)((String)PrimitiveAssociationSemantics.get(this.field, (String)"nullValueText", String.class, null))) : null;
    }

    public String getFieldNamePresentation() {
        return this.namePresenatation;
    }

    public String getFieldName() {
        return this.name;
    }

    public FieldValueRenderer<V> getValueRenderer() {
        return this.valueRenderer;
    }

    public boolean isWriteAccessible() {
        return ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).isWriteAccessible(this.getIssue(), (Entity)this.field);
    }

    public T getProjectCustomField() {
        return this.field;
    }

    public Entity getIssue() {
        return this.issue;
    }

    public void registerCallback(_FunctionTypes._void_P1_E0<? super String> callback) {
        String fieldName = this.getFieldName();
        Entity it = this.getIssue();
        ComponentCallback.getCallback(it).register(fieldName, callback);
    }

    private boolean showMandatoryFieldText(V v) {
        return (v == null && ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.issue, (String)"Issue")).isDraft(this.issue) || v != null && ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.issue, (String)"Issue")).isDraft(this.issue) && v instanceof Iterable && Sequence.fromIterable((Iterable)((Iterable)v)).isEmpty()) && (Boolean)PrimitiveAssociationSemantics.get(this.field, (String)"canBeEmpty", Boolean.class, null) == false;
    }

    private boolean verifyTypeAndNotificateFail(Entity issue) {
        if (((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field), (String)"AbstractCustomFieldPrototype")).getType(((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field)) == this.type) {
            return true;
        }
        String message = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CustomFieldWrapper.Type_of_custom_field_<b>{0}</b>_has_been_changed_<a_href_javascript_window_location_reload_>Reload</a>", new Object[]{PrimitiveAssociationSemantics.get((Entity)((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance(this.field, (String)"ProjectCustomField")).getPrototype((Entity)this.field), (String)"name", String.class, null)});
        Message.show(message, issue);
        return false;
    }

    public String getCssClass() {
        return this.getValueRenderer().getCssClass(this.getValue());
    }

    public CustomFieldType getType() {
        return this.type;
    }

    public V getValue() {
        return this.getFieldValue();
    }

    public void setValue(V value) {
        this.setFieldValue(value);
    }

    public static String getSetValueMessage() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CustomFieldWrapper.Set_value", new Object[0]);
    }
}

