/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.plugins;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import java.util.List;
import jetbrains.charisma.plugins.IssueAction;
import jetbrains.charisma.plugins.IssueActionsProvider;
import jetbrains.charisma.smartui.content.VoteIssueActionProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class IssueActionsProviders {
    private List<IssueActionsProvider> myProviders;

    public Iterable<IssueAction> getAllActions(final Iterable<Entity> projects) {
        return ListSequence.fromList(this.getProviders()).translate((_FunctionTypes._return_P1_E0)new ITranslator2<IssueActionsProvider, IssueAction>(){

            public Iterable<IssueAction> translate(IssueActionsProvider it) {
                return it.getActions(projects);
            }
        });
    }

    public Iterable<IssueAction> getApplicableActions(final Iterable<Entity> issues) {
        ISequence actions = ListSequence.fromList(this.getProviders()).translate((_FunctionTypes._return_P1_E0)new ITranslator2<IssueActionsProvider, IssueAction>(){

            public Iterable<IssueAction> translate(IssueActionsProvider it) {
                return it.getActions((Iterable<Entity>)Sequence.fromIterable((Iterable)issues).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, Entity>(){

                    public Entity select(Entity issue) {
                        return AssociationSemantics.getToOne((Entity)issue, (String)"project");
                    }
                }));
            }
        });
        return Sequence.fromIterable((Iterable)actions).where((_FunctionTypes._return_P1_E0)new IWhereFilter<IssueAction>(){

            public boolean accept(final IssueAction it) {
                return Sequence.fromIterable((Iterable)issues).all((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                    public boolean accept(Entity issue) {
                        return it.isApplicable(issue);
                    }
                });
            }
        });
    }

    public Iterable<IssueAction> getApplicableActionsForWebrPages(final Iterable<Entity> issues) {
        ISequence voteActions = Sequence.fromIterable(((VoteIssueActionProvider)ServiceLocator.getBean((String)"voteIssueActionProvider")).getActions()).where((_FunctionTypes._return_P1_E0)new IWhereFilter<IssueAction>(){

            public boolean accept(final IssueAction it) {
                return Sequence.fromIterable((Iterable)issues).all((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                    public boolean accept(Entity issue) {
                        return it.isApplicable(issue);
                    }
                });
            }
        });
        return Sequence.fromIterable(this.getApplicableActions(issues)).union(Sequence.fromIterable((Iterable)voteActions));
    }

    public List<IssueActionsProvider> getProviders() {
        return this.myProviders;
    }

    public void setProviders(List<IssueActionsProvider> value) {
        this.myProviders = value;
    }
}

