/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.refactoring;

import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.refactoring.AbstractRefactoringList;
import jetbrains.charisma.refactoring.PluggedRefactoringContainer;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.env.Environment;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.application.RuleEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Refactoring {
    public static boolean disableCaching = true;
    protected static Log log = LogFactory.getLog(Refactoring.class);
    private String name = this.getClass().getName();
    private boolean myRequiresRingToRun;

    public boolean shouldApply(Entity a) {
        return !ConfigurationUtil.isTestMode() && !((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"ApplicationMetaData")).refactoringApplied(this.getName(), a);
    }

    public void apply(Entity a) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void doUnit(String message, _FunctionTypes._return_P1_E0<? extends Integer, ? super Integer> unit) {
        RefactoringUtil.doUnit(message, unit, this.getName());
    }

    protected void doUnit(String message, int total, _FunctionTypes._return_P1_E0<? extends Integer, ? super Integer> unit) {
        RefactoringUtil.doUnit(message, total, unit, this.getName());
    }

    protected boolean requireTnx() {
        return true;
    }

    public boolean getRequiresRingToRun() {
        return this.myRequiresRingToRun;
    }

    public void setRequiresRingToRun(boolean value) {
        this.myRequiresRingToRun = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyAll(PluggedRefactoringContainer container) {
        long start = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting " + container.getName() + "..."));
        }
        PersistentEntityStoreImpl store = (PersistentEntityStoreImpl)((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore"));
        Environment env = store.getEnvironment();
        env.suspendGC();
        try {
            boolean cachingWasDisabled = store.getConfig().isCachingDisabled();
            Refactoring.setCachingDisabled(true);
            try {
                ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).addIgnoreThread();
                try {
                    IListSequence allRefactorings = ListSequence.fromList(new ArrayList());
                    ListSequence.fromList(container.getRefactoringLists()).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<AbstractRefactoringList>((List)allRefactorings){
                        final /* synthetic */ List val$allRefactorings;
                        {
                            this.val$allRefactorings = list;
                        }

                        public void visit(AbstractRefactoringList it) {
                            ListSequence.fromList((List)this.val$allRefactorings).addSequence((ISequence)ListSequence.fromList(it.getRefactorings()));
                        }
                    });
                    ListSequence.fromList((List)allRefactorings).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Refactoring>(){

                        public void visit(Refactoring it) {
                            Refactoring.applyRefactoring(it);
                        }
                    });
                }
                finally {
                    ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).removeIgnoreThread();
                }
            }
            finally {
                Refactoring.setCachingDisabled(cachingWasDisabled);
            }
        }
        finally {
            env.resumeGC();
        }
        int seconds = Math.round((float)(System.currentTimeMillis() - start) / 1000.0f);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Completed %s in %d min %d sec", container.getName(), seconds / 60, seconds % 60));
        }
    }

    private static void applyRefactoring(final Refactoring refactoring) {
        final Wrappers._boolean shouldApply = new Wrappers._boolean();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                shouldApply.value = refactoring.shouldApply((Entity)ServiceLocator.getBean((String)"applicationMetaData"));
            }
        });
        if (shouldApply.value) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"---------------------------------------------------");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Apply refactoring: " + refactoring.getName()));
            }
            if (refactoring.requireTnx()) {
                _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                    public void invoke() {
                        refactoring.apply((Entity)ServiceLocator.getBean((String)"applicationMetaData"));
                    }
                });
            } else {
                refactoring.apply((Entity)ServiceLocator.getBean((String)"applicationMetaData"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"---------------------------------------------------");
            }
        }
    }

    public static void setCachingDisabled(boolean disabled) {
        if (!disableCaching) {
            return;
        }
        PersistentEntityStoreConfig config = ((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getConfig();
        if (disabled != config.isCachingDisabled()) {
            config.setCachingDisabled(disabled);
        }
    }
}

