/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.rss;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.rss.IssueComment_RssItemTemplate;
import jetbrains.charisma.rss.RssUtil;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.RssTemplateFactory;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.security.IssueSecurityService;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.CentralManager;
import webr.framework.function.HtmlStringUtil;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.textBuilder.TextBuilder;
import webr.framework.url.UrlUtil;

public class IssueComments_RssTemplate
extends RssTemplateFactory {
    public IssueComments_RssTemplate() {
        super("IssueComments");
    }

    public ActionController createAction(String actionName, String windowId) {
        return new Action(actionName, windowId);
    }

    private class Action
    extends RssTemplateFactory.RSSAction {
        private String issueId;
        private Entity issue;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Action(String actionName, String windowId) {
            super((RssTemplateFactory)IssueComments_RssTemplate.this, actionName, windowId);
            String issueIdRequestValue = BaseApplication.getRequest().getParameter("issueId");
            if (issueIdRequestValue != null && issueIdRequestValue.length() > 0) {
                this.issueId = (String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString(issueIdRequestValue, String.class.getName());
            }
            boolean $nt$_7i1ygd_d0a0 = DnqUtils.getCurrentTransientSession() == null;
            TransientStoreSession ts1_7i1ygd_d0a0 = DnqUtils.beginTransientSession();
            boolean wasEx_7i1ygd_d0a0 = true;
            try {
                if (!RssUtil.loginGuestIfNullIsLogged()) {
                    return;
                }
                Entity found = IssueImpl.fromId(this.issueId);
                if (((IssueSecurityService)ServiceLocator.getBean((String)"issueSecurityService")).isAccessible(found)) {
                    this.issue = found;
                }
                wasEx_7i1ygd_d0a0 = false;
            }
            finally {
                if ($nt$_7i1ygd_d0a0 && ts1_7i1ygd_d0a0.isOpened()) {
                    if (wasEx_7i1ygd_d0a0) {
                        ts1_7i1ygd_d0a0.abort();
                    } else {
                        ts1_7i1ygd_d0a0.commit();
                    }
                }
            }
        }

        public boolean requiresBasicAuth() {
            return RssUtil.feedRequiresAuthentication();
        }

        public String getBasicAuthRealm() {
            return ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getApplicationName();
        }

        public RssTemplateFactory.RssTemplate createRssTemplate() {
            return new RssTemplateImpl();
        }

        private class RssTemplateImpl
        extends RssTemplateFactory.RssTemplate {
            public boolean hasAccess(TBuilderContext builderContext) {
                return RssUtil.isFeedAccessible();
            }

            public void renderChanel(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<rss version=\"2.0\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">");
                builderContext.appendNewLine();
                builderContext.increaseIndent();
                builderContext.appendIndent();
                builderContext.append("<channel>");
                builderContext.appendNewLine();
                builderContext.increaseIndent();
                builderContext.appendIndent();
                builderContext.append("<title>");
                builderContext.append(HtmlStringUtil.html((Object)((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueComments.{YouTrack}_-_Comments_to_{issue}", new Object[]{((CentralManager)ServiceLocator.getBean((String)"centralManager")).getApplicationName(), ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)Action.this.issue, (String)"Issue")).getId(Action.this.issue)})));
                builderContext.append("</title>");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("<link>");
                builderContext.append(HtmlStringUtil.html((Object)UrlUtil.getRssTemplateUri((String)"IssueComments", (QueryParameter[])new QueryParameter[]{QueryParameter.newQueryParameter((String)"issueId", (Object)Action.this.issueId)})));
                builderContext.append("</link>");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("<description>");
                builderContext.append(HtmlStringUtil.html((Object)((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueComments.Comments_to_{issue}", new Object[]{Action.this.issueId})));
                builderContext.append("</description>");
                builderContext.appendNewLine();
                for (Entity comment : QueryOperations.take((Iterable)(EntityOperations.equals((Entity)Action.this.issue, null) ? QueryOperations.empty((String)"IssueComment") : ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)Action.this.issue, (String)"Issue")).getAccessibleCommentsSorted(false, Action.this.issue)), (int)50)) {
                    IssueComment_RssItemTemplate itemTemplate = new IssueComment_RssItemTemplate();
                    IssueComment_RssItemTemplate.set$Comment(itemTemplate, comment);
                    builderContext.render((TextBuilder)itemTemplate, null);
                }
                builderContext.decreaseIndent();
                builderContext.appendIndent();
                builderContext.append("</channel>");
                builderContext.appendNewLine();
                builderContext.decreaseIndent();
                builderContext.appendIndent();
                builderContext.append("</rss>");
                builderContext.appendNewLine();
            }
        }
    }
}

