/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.service;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityAdapter;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class PredefindedUserChangesListener
extends EntityAdapter<Entity> {
    public void updatedSyncBeforeConstraints(Entity old, Entity current) {
        if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)old), (String)"login")) {
            this.checkCanUpdateUser(old, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.Renaming_{user_name}_is_prohibited", new Object[]{PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)old), (String)"login", String.class, (Object)"<no user>")}));
        }
    }

    public void removedSyncBeforeConstraints(Entity removed) {
        this.checkCanUpdateUser(removed, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.Removing_{user_name}_is_prohibited", new Object[]{PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)removed), (String)"login", String.class, (Object)"<no user>")}));
    }

    private void checkCanUpdateUser(Entity user, String errorMessage) {
        if (PredefindedUserChangesListener.eq_o93tbc_a0a0c(PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)user), (String)"login", String.class, (Object)"<no user>"), "guest")) {
            throw EntityOperations.isRemoved((Entity)user) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(errorMessage)) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(errorMessage, (Entity)((TransientEntity)user)));
        }
    }

    private static boolean eq_o93tbc_a0a0c(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

