/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.dto;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.BundleImpl;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.plugins.CustomFieldType;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.charisma.plugins.SuppliedField;
import jetbrains.charisma.service.UserProfileService;
import jetbrains.charisma.smartui.dto.CustomFieldEditorDTO;
import jetbrains.charisma.smartui.persistent.DetailLevelImpl;
import jetbrains.charisma.smartui.persistent.UserSearchRequest;
import jetbrains.charisma.smartui.watchFolder.StarService;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.exodus.util.StringHashMap;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;
import webr.framework.controller.BaseApplication;

public class IssueRequestDataHolder {
    private static String NAME = IssueRequestDataHolder.class.getName();
    private static int READ_COMMENT = 1;
    private static int CREATE_COMMENT = 2;
    private LongHashMap<LongHashSet> projectPermissions = new LongHashMap();
    private LongHashMap<Entity> projectPriority = new LongHashMap();
    private Map<EntityId, String> pcfToName = new HashMap();
    private Map<EntityId, CustomFieldEditorDTO> pcfToEditor = new HashMap();
    private Map<EntityId, CustomFieldType> nameToType = new HashMap();
    private LongHashMap<List<Entity>> projectToVisibleFields = new LongHashMap();
    private LongHashMap<List<Entity>> projectToConditionalFields = new LongHashMap();
    private Map<EntityId, Entity> projectCustomFieldPrototypes = new HashMap();
    private LongHashMap<List<Entity>> duplicateClustersUnflushed = new LongHashMap();
    private LongHashSet votesRecounted = new LongHashSet();
    private StringHashMap<Entity> projectCustomFields = new StringHashMap();
    private Map<Entity, Entity> watchFoldersToWatchRules = null;
    private Map<EntityId, String> bundleElementDialogs = new HashMap();
    private Boolean summaryMode;
    private Boolean hierarchyMode;
    private Boolean descriptionMode;
    private Boolean propertiesMode;
    private Boolean byVisible;
    private Boolean priorityVisible;
    private Entity verticalPropertiesIssue;
    private UserSearchRequest searchRequest;
    private Entity verticalPropertiesIssuePriorityField;
    private Entity star;
    private Boolean sidebarHidden;
    private Boolean tagsVisible;
    public boolean disabled;
    private Entity myMe;
    private DateTimeZone myMyTimeZone;
    private Locale myMyLocale;
    private String myDateFieldFormat;
    private boolean myMyExceptionCollapsed;
    private boolean myHasAccessToCommands;
    private boolean myIsGuest;
    private boolean myVerticalProperties;

    private IssueRequestDataHolder() {
        this.setMe(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
        GeneralUserProfile userProfile = ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getGeneralUserProfile(this.getMe());
        this.setMyTimeZone(userProfile.getTimeZone());
        this.setDateFieldFormat(userProfile.getDateFieldFormat());
        this.setMyLocale(userProfile.getLocale());
        this.setMyExceptionCollapsed(!((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getDisplayUserProfile(this.getMe()).isExceptionsExpanded());
        this.setHasAccessToCommands(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)this.getMe(), (String)"User")).hasAccessToCommands(this.getMe()));
        this.setIsGuest(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)this.getMe(), (String)"User")).isGuest(this.getMe()));
        this.setVerticalProperties(true);
    }

    @NotNull
    public CustomFieldType getCustomFieldType(Entity field) {
        EntityId id = field.getId();
        CustomFieldType type = this.nameToType.get(id);
        if (type == null) {
            type = ((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getPrototype(field), (String)"AbstractCustomFieldPrototype")).getType(((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getPrototype(field));
            this.nameToType.put(id, type);
        }
        return type;
    }

    public boolean hasReadCommentPermission(Entity p) {
        return this.hasPermission(p, READ_COMMENT);
    }

    public boolean hasCreateCommentPermission(Entity p) {
        return this.hasPermission(p, CREATE_COMMENT);
    }

    @NotNull
    public UserSearchRequest getSearchRequest() {
        UserSearchRequest result = this.searchRequest;
        if (result == null) {
            this.searchRequest = result = ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getSearchRequest(this.getMe());
        }
        return result;
    }

    public boolean isSummaryMode() {
        if (this.summaryMode == null) {
            this.summaryMode = EntityOperations.equals((Entity)((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getSearchRequest(this.getMe()).getDetailLevel(), (Object)DetailLevelImpl.SUMMARY.get());
        }
        return this.summaryMode;
    }

    public boolean isHierarchyMode() {
        if (this.hierarchyMode == null) {
            this.hierarchyMode = ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getSearchRequest(this.getMe()).isShowHierarchy();
        }
        return this.hierarchyMode;
    }

    public void setHierarchyMode(boolean v) {
        ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getSearchRequest(this.getMe()).setShowHierarchy(v);
        this.hierarchyMode = v;
    }

    public boolean isDescriptionMode() {
        if (this.descriptionMode == null) {
            this.descriptionMode = EntityOperations.equals((Entity)((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getSearchRequest(this.getMe()).getDetailLevel(), (Object)DetailLevelImpl.DESCRIPTION.get());
        }
        return this.descriptionMode;
    }

    public boolean isPropertiesMode() {
        if (this.propertiesMode == null) {
            this.propertiesMode = EntityOperations.equals((Entity)((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getSearchRequest(this.getMe()).getDetailLevel(), (Object)DetailLevelImpl.PROPERTIES.get());
        }
        return this.propertiesMode;
    }

    public boolean isByVisible() {
        if (this.byVisible == null) {
            this.byVisible = ((IField)ServiceLocator.getBean((String)"predefinedFieldBy")).isVisible(this.getMe());
        }
        return this.byVisible;
    }

    public List<Entity> getVisibleFields(final Entity i) {
        List visibleConditional;
        if (EntityOperations.equals((Entity)i, null) || EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)i, (String)"project"), null)) {
            return Collections.EMPTY_LIST;
        }
        Entity project = AssociationSemantics.getToOne((Entity)i, (String)"project");
        long projectId = this.getEntityLocalId(project);
        List visibleFields = (List)this.projectToVisibleFields.get(projectId);
        List visibleConditionalFields = (List)this.projectToConditionalFields.get(projectId);
        if (visibleFields == null || visibleConditionalFields == null) {
            final UserSearchRequest req = this.getSearchRequest();
            final Entity loggedInUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
            visibleFields = Sequence.fromIterable((Iterable)((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)project, (String)"Project")).getSortedFields(project)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return req.isVisible(IssueRequestDataHolder.this.getCustomFieldPrototype(it)) && ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).isReadAccessible(loggedInUser, it) && ((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)it, (String)"prototype"), (String)"AbstractCustomFieldPrototype")).getType(AssociationSemantics.getToOne((Entity)it, (String)"prototype")).isAccessibleInOldUi();
                }
            }).toListSequence();
            visibleConditionalFields = Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)visibleFields, (String)"ProjectCustomField", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("condition", null)))).toListSequence();
            this.projectToVisibleFields.put(projectId, (Object)visibleFields);
            if (QueryOperations.isEmpty((Iterable)visibleConditionalFields)) {
                visibleConditionalFields = Collections.EMPTY_LIST;
            }
            this.projectToConditionalFields.put(projectId, (Object)visibleConditionalFields);
        }
        return (visibleConditional = visibleConditionalFields) == Collections.EMPTY_LIST ? visibleFields : ListSequence.fromList((List)visibleFields).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !visibleConditional.contains(it) || ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).isVisibleInIssue(i, it);
            }
        }).toListSequence();
    }

    public String getProjectCustomFieldName(Entity f) {
        EntityId id = f.getId();
        String name = this.pcfToName.get(id);
        if (name == null) {
            name = ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)f, (String)"ProjectCustomField")).getTypeDependentId(f);
            this.pcfToName.put(id, name);
        }
        return name;
    }

    private CustomFieldEditorDTO getProjectCustomFieldEditorDto(Entity f) {
        EntityId id = f.getId();
        CustomFieldEditorDTO dto = this.pcfToEditor.get(id);
        if (dto == null) {
            String name = ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)f, (String)"ProjectCustomField")).getEditorTemplateName(f);
            dto = new CustomFieldEditorDTO(name, f);
            this.pcfToEditor.put(id, dto);
        }
        return dto;
    }

    public Object getProjectCustomFieldEditorData(Entity f) {
        return this.getProjectCustomFieldEditorDto((Entity)f).data;
    }

    public String getProjectCustomFieldEditor(Entity f) {
        return this.getProjectCustomFieldEditorDto((Entity)f).name;
    }

    @Nullable
    public Entity getPriority(@Nullable Entity p) {
        if (p == null) {
            return null;
        }
        long projectId = this.getEntityLocalId(p);
        Entity field = (Entity)this.projectPriority.get(projectId);
        if (field == null) {
            field = ((SuppliedField)ServiceLocator.getBean((String)"issuePriority")).getProjectField(p);
            this.projectPriority.put(projectId, (Object)field);
        }
        return field;
    }

    public boolean isPriorityVisible(Entity field) {
        if (this.priorityVisible == null) {
            this.priorityVisible = ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getSearchRequest(this.getMe()).isVisible(((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).getPrototype(field));
        }
        return this.priorityVisible;
    }

    private boolean hasPermission(Entity p, int permission) {
        if (p == null) {
            return false;
        }
        long projectId = this.getEntityLocalId(p);
        LongHashSet permissions = (LongHashSet)this.projectPermissions.get(projectId);
        if (permissions == null) {
            permissions = this.initPermissions(p);
            this.projectPermissions.put(projectId, (Object)permissions);
        }
        return permissions.contains((long)permission);
    }

    private LongHashSet initPermissions(Entity p) {
        LongHashSet permissions = new LongHashSet();
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)this.getMe(), (String)"User")).hasPermission(Permission.READ_COMMENT, p, this.getMe())) {
            permissions.add((long)READ_COMMENT);
        }
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)this.getMe(), (String)"User")).hasPermission(Permission.CREATE_COMMENT, p, this.getMe())) {
            permissions.add((long)CREATE_COMMENT);
        }
        return permissions;
    }

    private long getEntityLocalId(@NotNull Entity e) {
        return e.getId().getLocalId();
    }

    public Entity getCustomFieldPrototype(Entity pcf) {
        Entity entity = pcf;
        if (EntityOperations.equals((Entity)entity, null)) {
            return null;
        }
        EntityId id = entity.getId();
        Entity prototype = this.projectCustomFieldPrototypes.get(id);
        if (prototype == null && !((TransientEntity)(prototype = AssociationSemantics.getToOne((Entity)pcf, (String)"prototype"))).isReadonly()) {
            this.projectCustomFieldPrototypes.put(id, prototype);
        }
        return prototype;
    }

    @Nullable
    public List<Entity> getDuplicateClusterUnflushed(Entity root) {
        return (List)this.duplicateClustersUnflushed.get(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).getPersistentLocalId(root));
    }

    public void setDuplicateClusterUnflushed(Entity root, List<Entity> cluster) {
        this.duplicateClustersUnflushed.put(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).getPersistentLocalId(root), cluster);
    }

    public boolean areVotesRecountedFor(Entity issue) {
        return this.votesRecounted.contains(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getPersistentLocalId(issue));
    }

    public void votesRecountedFor(Entity issue) {
        this.votesRecounted.add(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getPersistentLocalId(issue));
    }

    public void setProjectCustomField(@Nullable Entity p, String name, @Nullable Entity pcf) {
        if (!EntityOperations.equals((Entity)p, null)) {
            this.projectCustomFields.put(p.getId().toString() + '#' + name, (Object)pcf);
        }
    }

    public boolean hasProjectCustomField(@Nullable Entity p, String name) {
        return !EntityOperations.equals((Entity)p, null) && this.projectCustomFields.containsKey((Object)(p.getId().toString() + '#' + name));
    }

    @Nullable
    public Entity getProjectCustomField(@Nullable Entity p, String name) {
        if (EntityOperations.equals((Entity)p, null)) {
            return null;
        }
        String id = p.getId().toString() + '#' + name;
        Entity field = (Entity)this.projectCustomFields.get((Object)id);
        if (EntityOperations.isRemoved((Entity)field)) {
            this.projectCustomFields.remove((Object)id);
            return null;
        }
        return field;
    }

    public boolean watchRulesInited() {
        return this.watchFoldersToWatchRules != null;
    }

    public void initWatchRules() {
        this.watchFoldersToWatchRules = new HashMap();
    }

    public void setWatchRuleByWatchFolder(Entity rule) {
        this.watchFoldersToWatchRules.put(AssociationSemantics.getToOne((Entity)rule, (String)"watchFolder"), rule);
    }

    public Entity getWatchRuleByWatchFolder(Entity folder) {
        return this.watchFoldersToWatchRules.get(folder);
    }

    public String getBundleElementDialog(Entity bundle) {
        EntityId id = bundle.getId();
        if (this.bundleElementDialogs.containsKey(id)) {
            return this.bundleElementDialogs.get(id);
        }
        String result = ((BundleImpl)DnqUtils.getPersistentClassInstance((Entity)bundle, (String)"Bundle")).isEditable(bundle) ? ((BundleImpl)DnqUtils.getPersistentClassInstance((Entity)bundle, (String)"Bundle")).getElementDialog(bundle) : null;
        this.bundleElementDialogs.put(id, result);
        return result;
    }

    public boolean isVerticalPropertiesIssuePriorityField(Entity issue, Entity cf) {
        if (EntityOperations.equals((Entity)this.verticalPropertiesIssue, null)) {
            this.verticalPropertiesIssue = issue;
        } else if (!EntityOperations.equals((Entity)this.verticalPropertiesIssue, (Object)issue)) {
            return false;
        }
        if (EntityOperations.equals((Entity)this.verticalPropertiesIssuePriorityField, null)) {
            this.verticalPropertiesIssuePriorityField = ((SuppliedField)ServiceLocator.getBean((String)"issuePriority")).getProjectField(AssociationSemantics.getToOne((Entity)issue, (String)"project"));
        }
        return EntityOperations.equals((Entity)cf, (Object)this.verticalPropertiesIssuePriorityField);
    }

    public Entity getStar() {
        if (this.star == null) {
            this.star = ((StarService)ServiceLocator.getBean((String)"starService")).findStar(this.getMe());
        }
        return this.star;
    }

    public boolean areTagsVisible() {
        if (this.tagsVisible == null) {
            this.tagsVisible = ((IField)ServiceLocator.getBean((String)"predefinedFieldTag")).isVisible(this.getMe());
        }
        return this.tagsVisible;
    }

    public boolean isSidebarHidden() {
        if (this.sidebarHidden == null) {
            this.sidebarHidden = !((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getDisplayUserProfile(this.getMe()).isShowSidebar();
        }
        return this.sidebarHidden;
    }

    public Entity getMe() {
        return this.myMe;
    }

    private void setMe(Entity value) {
        this.myMe = value;
    }

    public DateTimeZone getMyTimeZone() {
        return this.myMyTimeZone;
    }

    private void setMyTimeZone(DateTimeZone value) {
        this.myMyTimeZone = value;
    }

    public Locale getMyLocale() {
        return this.myMyLocale;
    }

    private void setMyLocale(Locale value) {
        this.myMyLocale = value;
    }

    public String getDateFieldFormat() {
        return this.myDateFieldFormat;
    }

    private void setDateFieldFormat(String value) {
        this.myDateFieldFormat = value;
    }

    public boolean getMyExceptionCollapsed() {
        return this.myMyExceptionCollapsed;
    }

    private void setMyExceptionCollapsed(boolean value) {
        this.myMyExceptionCollapsed = value;
    }

    public boolean getHasAccessToCommands() {
        return this.myHasAccessToCommands;
    }

    private void setHasAccessToCommands(boolean value) {
        this.myHasAccessToCommands = value;
    }

    public boolean getIsGuest() {
        return this.myIsGuest;
    }

    private void setIsGuest(boolean value) {
        this.myIsGuest = value;
    }

    public boolean getVerticalProperties() {
        return this.myVerticalProperties;
    }

    public void setVerticalProperties(boolean value) {
        this.myVerticalProperties = value;
    }

    @Nullable
    public static IssueRequestDataHolder get() {
        if (!BaseApplication.isInsideRequestProcessing()) {
            return null;
        }
        HttpServletRequest req = BaseApplication.getRequest();
        IssueRequestDataHolder dto = (IssueRequestDataHolder)req.getAttribute(NAME);
        if (dto == null) {
            dto = new IssueRequestDataHolder();
            req.setAttribute(NAME, (Object)dto);
        }
        return dto;
    }

    public static IssueRequestDataHolder getDontCreate() {
        if (!BaseApplication.isInsideRequestProcessing()) {
            return null;
        }
        IssueRequestDataHolder result = (IssueRequestDataHolder)BaseApplication.getRequest().getAttribute(NAME);
        if (result != null && result.disabled) {
            return null;
        }
        return result;
    }
}

