/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.highlight;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.smartui.filter.FilterData;
import jetbrains.charisma.smartui.highlight.StringUtils;
import jetbrains.charisma.smartui.highlight.Token;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.service.MarkupRenderFactory;
import jetbrains.youtrack.textindex.TextIndexManagerCompat;
import webr.framework.controller.BaseApplication;

public class IssueFieldsDecorator {
    public static final int DESCRIPTION_PREVIEW_LENGTH = 200;
    public static final int DESCRIPTION_SURROUND_LETTERS = 15;

    private IssueFieldsDecorator() {
    }

    public static String getHightlighed(String text, String[] highlightWords, int length, int space) {
        if (text == null || text.length() == 0) {
            return "";
        }
        String highlightQuery = IssueFieldsDecorator.join(highlightWords);
        return IssueFieldsDecorator.toString(IssueFieldsDecorator.parse(text, highlightQuery, space, length), highlightQuery);
    }

    public static String getSummary(Entity issue, FilterData filterData) {
        Iterable<String> textSearch;
        String summary = (String)PrimitiveAssociationSemantics.get((Entity)issue, (String)"summary", String.class, null);
        if (summary == null) {
            return "";
        }
        if (filterData != null && Sequence.fromIterable(textSearch = filterData.getFilter().getTextSearch((IField)ServiceLocator.getBean((String)"predefinedFieldSummary"))).isNotEmpty()) {
            String[] highlightWords = (String[])Sequence.fromIterable(textSearch).toGenericArray(String.class);
            int length = 200;
            int space = 15;
            String highlightQuery = IssueFieldsDecorator.join(highlightWords);
            return IssueFieldsDecorator.toString(IssueFieldsDecorator.parse(summary, highlightQuery, space, length), highlightQuery);
        }
        return BaseHtmlStringUtil.html((Object)StringUtils.substring(summary, 0, 200));
    }

    private static String getIssueDescription(Entity issue, int maxLen) {
        String text = maxLen == -1 ? PrimitiveAssociationSemantics.getBlobAsString((Entity)issue, (String)"description") : StringUtils.substring(PrimitiveAssociationSemantics.getBlobAsString((Entity)issue, (String)"description"), 0, maxLen);
        String description = ((MarkupRenderFactory)ServiceLocator.getBean((String)"markupRenderFactory")).createBuilder().markdown(((Boolean)PrimitiveAssociationSemantics.get((Entity)issue, (String)"usesMarkdown", Boolean.class, null)).booleanValue()).contextIssue(issue).removeMarkup(text);
        return description;
    }

    public static String getDescription(Entity issue, FilterData filterData) {
        Iterable<String> textSearch;
        if (filterData != null && Sequence.fromIterable(textSearch = filterData.getFilter().getTextSearch((IField)ServiceLocator.getBean((String)"predefinedFieldDescription"))).isNotEmpty()) {
            String[] highlightWords = (String[])Sequence.fromIterable(textSearch).toGenericArray(String.class);
            String clean = IssueFieldsDecorator.getIssueDescription(issue, -1);
            int length = 200;
            int space = 15;
            String highlightQuery = IssueFieldsDecorator.join(highlightWords);
            return IssueFieldsDecorator.toString(IssueFieldsDecorator.parse(clean, highlightQuery, space, length), highlightQuery);
        }
        return BaseHtmlStringUtil.html((Object)IssueFieldsDecorator.getIssueDescription(issue, 200));
    }

    public static String getUnfurlDescription(Entity issue) {
        String originalDescription = PrimitiveAssociationSemantics.getBlobAsString((Entity)issue, (String)"description");
        if (originalDescription == null || originalDescription.length() == 0) {
            return "\u00a0";
        }
        String text = StringUtils.substring(originalDescription, 0, 200);
        String description = ((MarkupRenderFactory)ServiceLocator.getBean((String)"markupRenderFactory")).createBuilder().markdown(((Boolean)PrimitiveAssociationSemantics.get((Entity)issue, (String)"usesMarkdown", Boolean.class, null)).booleanValue()).contextIssue(issue).removeMarkup(text);
        description = StringUtils.stripEnd(description.replaceAll("\\s+", " "), " \n\r\t");
        if (text.length() < originalDescription.length()) {
            description = description + "\u2026";
        }
        return description.replace('<', '\u1438').replace('>', '\u1433');
    }

    private static List<Token> parse(String text, String highlightWords, int space, int maxLength) {
        List offsets = ((TextIndexManagerCompat)ServiceLocator.getBean((String)"textIndexManager")).getOffsets(text, highlightWords);
        if (text.length() <= maxLength) {
            return IssueFieldsDecorator.parseFullText(text, offsets);
        }
        return IssueFieldsDecorator.parseSnapshot(text, offsets, space, maxLength);
    }

    private static List<Token> parseFullText(String text, List<int[]> offsets) {
        int e;
        int[] offset;
        int s;
        IListSequence tokens = ListSequence.fromList(new ArrayList());
        int cur = 0;
        int len = text.length();
        Iterator<int[]> iterator = offsets.iterator();
        while (iterator.hasNext() && (s = (offset = iterator.next())[0]) <= len && (e = offset[1]) <= len) {
            if (cur < s) {
                ListSequence.fromList((List)tokens).addElement((Object)Token.plain(text.substring(cur, s)));
            }
            if (s < e) {
                if (BaseApplication.isInsideRequestProcessing() && BaseApplication.getRequest().getServletPath().contains("/api")) {
                    ListSequence.fromList((List)tokens).addElement((Object)Token.plain(text.substring(s, e)));
                } else {
                    ListSequence.fromList((List)tokens).addElement((Object)Token.highlight(text.substring(s, e)));
                }
            }
            cur = e;
        }
        ListSequence.fromList((List)tokens).addElement((Object)Token.plain(text.substring(cur)));
        return tokens;
    }

    public static List<Token> parseSnapshot(String text, List<int[]> offsets, int space, int maxLength) {
        int firstOffsetStart;
        IListSequence tokens = ListSequence.fromList(new ArrayList());
        int baseOffset = 0;
        int[] firstOffset = (int[])ListSequence.fromList(offsets).first();
        if (firstOffset != null && (firstOffsetStart = firstOffset[0]) > Token.ELLIPSIS_LENGTH + space) {
            baseOffset = firstOffsetStart - space;
        }
        int currentPosition = 0;
        if (baseOffset > 0) {
            ListSequence.fromList((List)tokens).addElement((Object)Token.ellipsis());
            currentPosition = baseOffset;
        }
        for (int[] offset : ListSequence.fromList(offsets)) {
            int s = offset[0];
            int e = offset[1];
            if (currentPosition < s) {
                int plainTextEnd = Math.min(s, baseOffset + maxLength);
                ListSequence.fromList((List)tokens).addElement((Object)Token.plain(StringUtils.substring(text, currentPosition, plainTextEnd)));
                currentPosition = plainTextEnd;
            }
            if (s < e && s < baseOffset + maxLength) {
                if (BaseApplication.isInsideRequestProcessing() && BaseApplication.getRequest().getServletPath().contains("/api")) {
                    ListSequence.fromList((List)tokens).addElement((Object)Token.plain(StringUtils.substring(text, s, e)));
                } else {
                    ListSequence.fromList((List)tokens).addElement((Object)Token.highlight(StringUtils.substring(text, s, e)));
                }
                currentPosition = e;
            }
            if (currentPosition < baseOffset + maxLength) continue;
            break;
        }
        if (currentPosition < text.length()) {
            int plainTextEnd = Math.min(text.length(), baseOffset + maxLength);
            ListSequence.fromList((List)tokens).addElement((Object)Token.plain(StringUtils.substring(text, currentPosition, plainTextEnd)));
            currentPosition = plainTextEnd;
        }
        if (currentPosition < text.length()) {
            ListSequence.fromList((List)tokens).addElement((Object)Token.ellipsis());
        }
        return tokens;
    }

    private static String toString(List<Token> tokens, String highlightWords) {
        StringBuilder builder = new StringBuilder();
        for (Token it : ListSequence.fromList(tokens)) {
            it.append(builder, highlightWords);
        }
        return builder.toString();
    }

    private static String join(String[] highlightWords) {
        if (highlightWords == null || highlightWords.length == 0) {
            return "";
        }
        if (highlightWords.length == 1) {
            return highlightWords[0];
        }
        return IterableUtils.join((Iterable)Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])highlightWords)), (String)" ");
    }
}

