/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.highlight;

import jetbrains.charisma.smartui.highlight.Operation;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;

public class Token {
    public static final String ELLIPSIS = " ... ";
    public static final int ELLIPSIS_LENGTH = " ... ".length();
    private String word;
    private Operation operation;

    private Token(String word, Operation operation) {
        this.word = word;
        this.operation = operation;
    }

    public void append(StringBuilder builder, String highlightWords) {
        switch (this.operation) {
            case PLAIN: {
                builder.append(BaseHtmlStringUtil.html((Object)this.word));
                break;
            }
            case HIGHLIGHT: {
                builder.append("<span");
                builder.append(" class=\"").append("highlightedWord");
                builder.append("\"");
                builder.append(" title=\"").append(BaseHtmlStringUtil.html((Object)highlightWords)).append("\"");
                builder.append(">");
                builder.append(BaseHtmlStringUtil.html((Object)this.word));
                builder.append("</span>");
                break;
            }
            case ELLIPSIS: {
                builder.append(ELLIPSIS);
                break;
            }
        }
    }

    public int hashCode() {
        return (this.word != null && this.word.length() > 0 ? this.word.hashCode() : 0) ^ this.operation.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Token)) {
            return false;
        }
        Token that = (Token)object;
        return Token.eq_o3xm4_a0a3a2(this.word, that.word) && this.operation.equals((Object)that.operation);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public String getWord() {
        return this.word;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public static Token plain(String text) {
        return new Token(text, Operation.PLAIN);
    }

    public static Token ellipsis() {
        return new Token(null, Operation.ELLIPSIS);
    }

    public static Token highlight(String text) {
        return new Token(text, Operation.HIGHLIGHT);
    }

    private static boolean eq_o3xm4_a0a3a2(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

