/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.panel.attachment;

import eu.medsea.mimeutil.MimeType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.charisma.plugins.AttachmentPreviewTemplate;
import jetbrains.charisma.plugins.AttachmentPreviewTemplates;
import jetbrains.charisma.smartui.panel.attachment.DefaultFilePreviewTemplate;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public class FilePreviewFactory {
    private static Map<String, AttachmentPreviewTemplate> CACHED_TEMPLATES = new ConcurrentHashMap<String, AttachmentPreviewTemplate>();
    private static DefaultFilePreviewTemplate DEFAULT_TEMPLATE = new DefaultFilePreviewTemplate();

    public static AttachmentPreviewTemplate getPreviewForFile(Entity file) {
        String mimeType = ((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)file, (String)"PersistentFile")).getMimeType(file);
        AttachmentPreviewTemplate template = CACHED_TEMPLATES.get(mimeType);
        if (template == null) {
            template = DEFAULT_TEMPLATE;
            MimeType mime = new MimeType(mimeType);
            for (AttachmentPreviewTemplate preview : ListSequence.fromList(((AttachmentPreviewTemplates)ServiceLocator.getBean((String)"attachmentPreviews")).getPreviews())) {
                if (!preview.getType().getMediaType().equals(mime.getMediaType())) continue;
                if (preview.getType().getSubType().equals(mime.getSubType())) {
                    template = preview;
                    break;
                }
                if (!preview.getType().getSubType().equals("*")) continue;
                template = preview;
            }
            CACHED_TEMPLATES.put(mimeType, template);
        }
        return template;
    }
}

