/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.panel.links;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.links.persistent.DirectedLink;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.links.persistent.Link;
import jetbrains.charisma.links.persistent.LinkAssociationsCache;
import jetbrains.charisma.links.persistent.LinkDirection;
import jetbrains.charisma.links.persistent.LinkNameTargetOutward;
import jetbrains.charisma.links.persistent.LinksModelIterable;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.DatabaseUtils;
import jetbrains.charisma.smartui.panel.links.LinkImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.backports.LinkedList;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permissions;
import org.joda.time.DateTimeFieldType;

public class IssuesView {
    public static final Integer DEFAULT_MAX_SHOW = 20;
    public final int maxShow;
    protected final Entity issue;
    protected int size = -1;
    protected int permittedIssuesSize = -1;
    protected boolean hasLinks;
    protected Map<DirectedLink, LinkedIssuesInfo> linkedIssues;
    protected Map<DirectedLink, Integer> more;
    protected Map<DirectedLink, Integer> show;

    public IssuesView(Entity issue, int maxShow) {
        this.issue = issue;
        this.maxShow = maxShow;
        this.init();
    }

    private IssuesView(Entity issue) {
        this(issue, DEFAULT_MAX_SHOW);
    }

    public void load() {
        if (this.size < 0) {
            int count = 0;
            IMapSequence protoCache = MapSequence.fromMap(new HashMap());
            EntityIdSet distinctLinkedIds = EntityIdSetFactory.newSet();
            EntityIdSet accessibleIssues = null;
            for (LinkNameTargetOutward data : Sequence.fromIterable(this.getIterable())) {
                EntityId id;
                this.hasLinks = true;
                Entity prototype = data.prototype();
                long protoId = prototype.getId().getLocalId();
                Tuples._3 names = (Tuples._3)MapSequence.fromMap((Map)protoCache).get((Object)protoId);
                if (names == null) {
                    String sourceToTarget = ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)prototype, (String)"IssueLinkPrototype")).getSourceToTargetPresentation(prototype);
                    names = (Boolean)PrimitiveAssociationSemantics.get((Entity)prototype, (String)"directed", Boolean.class, null) != false ? MultiTuple.from((Object)sourceToTarget, (Object)((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)prototype, (String)"IssueLinkPrototype")).getTargetToSourcePresentation(prototype), (Object)true) : MultiTuple.from((Object)sourceToTarget, (Object)sourceToTarget, (Object)false);
                    MapSequence.fromMap((Map)protoCache).put((Object)protoId, (Object)names);
                }
                DirectedLink directedLink = data.outward() != false ? new DirectedLink(prototype, (Boolean)names._2() != false ? LinkDirection.OUTWARD : LinkDirection.BOTH, (String)names._0()) : new DirectedLink(prototype, (Boolean)names._2() != false ? LinkDirection.INWARD : LinkDirection.BOTH, (String)names._1());
                LinkedIssuesInfo linkedIssues = (LinkedIssuesInfo)MapSequence.fromMap(this.linkedIssues).get((Object)directedLink);
                if (linkedIssues == null) {
                    linkedIssues = new LinkedIssuesInfo();
                    MapSequence.fromMap(this.linkedIssues).put((Object)directedLink, (Object)linkedIssues);
                }
                Entity target = data.target();
                if (accessibleIssues == null) {
                    EntityIterable allLinkedIssues = DnqUtils.getCurrentTransientSession().createPersistentEntityIterableWrapper((EntityIterable)AssociationSemantics.getToMany((Entity)this.issue, (Set)MapSequence.fromMap(((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociations(LinkDirection.BOTH)).keySet()));
                    accessibleIssues = DatabaseUtils.toIdSet(((Permissions)ServiceLocator.getBean((String)"permissions")).apply(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Iterable)allLinkedIssues));
                }
                if (accessibleIssues.contains(id = target.getId()) && !linkedIssues.idSet.contains(id)) {
                    linkedIssues.idSet = linkedIssues.idSet.add(id);
                    distinctLinkedIds = distinctLinkedIds.add(id);
                    LinkImpl link = new LinkImpl(directedLink.getPrototype(), this.issue, target, data.outward(), (String)names._0(), (String)names._1(), data.linkName());
                    if (DateTimeOperations.compare((Long)((Long)PrimitiveAssociationSemantics.get((Entity)target, (String)"resolved", null)), (CompareType)CompareType.EQ, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
                        linkedIssues.unresolvedCount++;
                        ListSequence.fromList((List)linkedIssues.issueLinks).insertElement(0, (Object)link);
                    } else {
                        ListSequence.fromList((List)linkedIssues.issueLinks).addElement((Object)link);
                    }
                }
                ++count;
            }
            Iterator<DirectedLink> itr = this.linkedIssues.keySet().iterator();
            while (itr.hasNext()) {
                DirectedLink link = itr.next();
                LinkedIssuesInfo linkedIssuesInfo = this.linkedIssues.get(link);
                List all = linkedIssuesInfo.issueLinks;
                if (ListSequence.fromList((List)all).isEmpty()) {
                    itr.remove();
                    continue;
                }
                IListSequence page = ListSequence.fromList((List)all).take(this.getMax(link).intValue()).toListSequence();
                this.linkedIssues.put(link, new LinkedIssuesInfo((List<Link>)page, linkedIssuesInfo.unresolvedCount));
                this.more.put(link, ListSequence.fromList((List)all).count() - ListSequence.fromList((List)page).count());
            }
            this.size = count;
            this.permittedIssuesSize = distinctLinkedIds.count();
        }
    }

    protected Iterable<LinkNameTargetOutward> getIterable() {
        return new LinksModelIterable(this.issue, ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAssociations(LinkDirection.BOTH));
    }

    public void init() {
        this.size = -1;
        this.hasLinks = false;
        this.more = new HashMap<DirectedLink, Integer>();
        this.linkedIssues = new LinkedHashMap<DirectedLink, LinkedIssuesInfo>();
    }

    public Entity getIssue() {
        return this.issue;
    }

    @Deprecated
    public int getSize() {
        this.load();
        return this.size;
    }

    public int getPermittedIssuesSize() {
        this.load();
        return this.permittedIssuesSize;
    }

    public boolean hasLinks() {
        this.load();
        return this.hasLinks;
    }

    public Map<DirectedLink, LinkedIssuesInfo> getLinkedIssues() {
        this.load();
        return this.linkedIssues;
    }

    public int getMore(DirectedLink link) {
        return (Integer)MapSequence.fromMap(this.more).get((Object)link);
    }

    protected Integer getMax(DirectedLink link) {
        if (this.show == null) {
            return this.maxShow;
        }
        Integer max = (Integer)MapSequence.fromMap(this.show).get((Object)link);
        if (max == null) {
            return this.maxShow;
        }
        return max;
    }

    public static IssuesView get(Entity issue) {
        return new IssuesView(issue);
    }

    public class LinkedIssuesInfo {
        private final List<Link> issueLinks;
        private int unresolvedCount = 0;
        private EntityIdSet idSet;

        private LinkedIssuesInfo() {
            this.issueLinks = ListSequence.fromList((List)new LinkedList());
            this.idSet = EntityIdSetFactory.newSet();
        }

        public LinkedIssuesInfo(List<Link> issueLinks, int unresolvedCount) {
            this.issueLinks = issueLinks;
            this.unresolvedCount = unresolvedCount;
        }

        public List<Link> getIssueLinks() {
            return this.issueLinks;
        }

        public int getUnresolvedCount() {
            return this.unresolvedCount;
        }
    }
}

