/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.parser.filterCreator;

import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.FieldAlias;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.LocalContext;
import jetbrains.youtrack.api.parser.Suggestable;
import jetbrains.youtrack.api.parser.Suggestion;
import jetbrains.youtrack.api.parser.SuggestionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseFieldNode
implements Suggestable {
    private IField field;
    private FieldAlias alias;
    protected final int matchingStart;

    public BaseFieldNode(IField c, FieldAlias alias) {
        this(c, alias, 0);
    }

    public BaseFieldNode(IField c, FieldAlias alias, int matchingStart) {
        this.field = c;
        this.alias = alias;
        this.matchingStart = matchingStart;
    }

    public Suggestion getSuggestion(@NotNull LocalContext context, String matching, int completionStart, int completionEnd) {
        return this.getSuggestion(matching, completionStart, completionEnd, this.getSuggestionDescription());
    }

    public String getSuggestionDescription() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("BaseFieldNode.by_{field_name}", new Object[]{this.field.getPresentation()});
    }

    @Nullable
    public Suggestion getSuggestion(String matching, int completionStart, int completionEnd, String description) {
        if (this.alias.shouldSuggest()) {
            return new Suggestion(this.alias.getAlias(), description, completionStart, completionEnd, this.matchingStart, this.matchingStart + matching.length(), SuggestionType.CATEGORY_NAME);
        }
        return null;
    }

    public IField getField() {
        return this.field;
    }

    public FieldAlias getFieldAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseFieldNode)) {
            return false;
        }
        BaseFieldNode that = (BaseFieldNode)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String getName() {
        return this.alias.getAlias();
    }

    public boolean isPrimary() {
        return this.matchingStart == 0;
    }
}

