/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.smartui.colorPicker.pallete.IndexedPallete;
import jetbrains.charisma.smartui.watchFolder.SpecialFolders;
import jetbrains.charisma.smartui.watchFolder.StarService;
import jetbrains.charisma.smartui.watchFolder.WatchFolderImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.l10n.LocalizationService;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.security.IssueSecurityService;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.watchFolder.RuleType;
import jetbrains.youtrack.core.watchFolder.WatchRuleImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.url.UrlUtil;

public class IssueTagImpl
extends WatchFolderImpl {
    private static String __ENTITY_TYPE__ = "IssueTag";
    public static final String ID_PREFIX = "$t$";
    public static final int MAX_LENGHT = 50;

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(Entity owner, String name, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        UndirectedAssociationSemantics.setManyToOne((Entity)owner, (String)"tags", (String)"owner", (Entity)entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)name), String.class);
        return entity;
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        return entity;
    }

    public String getDisplayName(Entity entity) {
        super.getDisplayName(entity);
        return ((IField)ServiceLocator.getBean((String)"predefinedFieldTag")).getPresentation();
    }

    @Override
    public void executeBeforeFlushTrigger(final Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        if ((EntityOperations.isNew((Entity)entity) || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"name")) && !((LocalizationService)ServiceLocator.getBean((String)"localizationController")).isTranslationInProgress()) {
            if (!QueryOperations.isEmpty((Iterable)Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"owner"), (String)"tags"), (String)"IssueTag", (NodeBase)new PropertyEqual("name", (Comparable)((Object)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)))))).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return !EntityOperations.equals((Entity)it, (Object)entity);
                }
            }))) {
                throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueTag.User_already_has_tag_with_name", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)}))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueTag.User_already_has_tag_with_name", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)}), (Entity)((TransientEntity)entity)));
            }
            if (!((StarService)ServiceLocator.getBean((String)"starService")).isStar(entity) && !QueryOperations.isEmpty((Iterable)Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"IssueTag")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return ((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"WatchFolder")).isAccessible(Operation.READ, AssociationSemantics.getToOne((Entity)entity, (String)"owner"), it) && ((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)).equalsIgnoreCase((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())) && !EntityOperations.equals((Entity)it, (Object)entity);
                }
            }))) {
                throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueTag.Tag_with_the_same_name_already_exists", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)}))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueTag.Tag_with_the_same_name_already_exists", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)}), (Entity)((TransientEntity)entity)));
            }
        }
    }

    @Override
    public Entity getOwner(Entity entity) {
        return AssociationSemantics.getToOne((Entity)entity, (String)"owner");
    }

    public String getTitle(Entity entity) {
        if (((IssueTagImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueTag")).isExplicit(entity)) {
            if (EntityOperations.equals((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Object)AssociationSemantics.getToOne((Entity)entity, (String)"owner"))) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueTag.Tag_created_by_you", new Object[0]);
            }
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueTag.Tag_created_by_{0}", new Object[]{PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"owner"), (String)"fullName", String.class, null)});
        }
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueTag.Starred_by_me", new Object[0]);
    }

    @Override
    public String getNotificationTitle(Entity user, Entity entity) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueTag._{tag_name}_tag", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())});
    }

    public String getCssClass(Entity entity) {
        return IndexedPallete.getCssClassByIndex((Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"cssClass", Integer.class, null));
    }

    public IndexedPallete getColor(Entity entity) {
        return IndexedPallete.getByIndex((Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"cssClass", Integer.class, null));
    }

    public boolean isExplicit(Entity entity) {
        return !((StarService)ServiceLocator.getBean((String)"starService")).isStar(entity);
    }

    public String getUrlUnsafe(String query, Integer pageNum, Entity entity) {
        return UrlUtil.getHtmlTemplateUri((String)"Tag", (String)"id", (QueryParameter[])new QueryParameter[]{new QueryParameter("id", (Object)SpecialFolders.getFolderId(entity), (TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")), new QueryParameter("p", (Object)pageNum, (TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")), new QueryParameter("q", (Object)query, (TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager"))});
    }

    public void tag(Entity issue, Entity entity) {
        if (((IssueTagImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueTag")).canTagUntagIssue(issue, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), entity)) {
            UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"issues", (String)"tags", (Entity)issue);
        }
    }

    public void untag(Entity issue, Entity entity) {
        if (((IssueTagImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueTag")).canTagUntagIssue(issue, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), entity)) {
            UndirectedAssociationSemantics.removeManyToMany((Entity)entity, (String)"issues", (String)"tags", (Entity)issue);
        }
    }

    public boolean canTagUntagIssue(Entity issue, Entity user, Entity entity) {
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isSystem(user)) {
            return true;
        }
        if (this.isAccessible(Operation.UPDATE, user, entity)) {
            return true;
        }
        if (((StarService)ServiceLocator.getBean((String)"starService")).isStar(entity) && ((IssueSecurityService)ServiceLocator.getBean((String)"issueSecurityService")).isAccessible(issue, Operation.UPDATE_WATCHES, user)) {
            return true;
        }
        return this.isAccessible(Operation.READ, user, entity) && ((IssueSecurityService)ServiceLocator.getBean((String)"issueSecurityService")).isAccessible(issue, Operation.PRIVATE_UPDATE, user);
    }

    private static Entity constructor(Entity owner, String name) {
        return ((IssueTagImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(owner, name, __ENTITY_TYPE__);
    }

    public static Entity constructor() {
        return ((IssueTagImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Iterable<Entity> applyPermissions(Entity user, Iterable<Entity> issueTags) {
        if (QueryOperations.isEmpty(issueTags)) {
            return QueryOperations.empty((String)"IssueTag");
        }
        TreeKeepingEntityIterable ownTags = QueryOperations.query(issueTags, (String)"IssueTag", (NodeBase)new LinkEqual("owner", user));
        return QueryOperations.union((Iterable)ownTags, WatchFolderImpl.whereSharedIsVisible(user, issueTags));
    }

    public static Iterable<Entity> whereExplicit(Iterable<Entity> issueTags) {
        return QueryOperations.query(issueTags, (String)"IssueTag", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("name", (Comparable)((Object)((StarService)ServiceLocator.getBean((String)"starService")).getStarName()))));
    }

    public static Entity getTag(Entity owner, String name, boolean create) {
        final String starName = ((StarService)ServiceLocator.getBean((String)"starService")).getStarName();
        if (starName.equalsIgnoreCase(name)) {
            Entity t = QueryOperations.getFirst((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)owner, (String)"tags")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return starName.equalsIgnoreCase((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
                }
            }));
            if (EntityOperations.equals((Entity)t, null) && create && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)owner, (String)"User")).isGuest(owner)) {
                t = IssueTagImpl.findOrCreate(owner, starName, new String[]{"owner", "name"});
                WatchRuleImpl.getOrCreate((Entity)owner, (Entity)t, (int)RuleType.getTagsRuleMaskWithPin());
            }
            return t;
        }
        Entity t = QueryOperations.getFirst((Iterable)QueryOperations.query(IssueTagImpl.getAllVisibleTags(owner), (String)"IssueTag", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
        if (EntityOperations.equals((Entity)t, null) && create && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)owner, (String)"User")).hasPermission(Permission.CREATE_WATCH_FOLDER, owner)) {
            t = IssueTagImpl.findOrCreate(owner, name, new String[]{"owner", "name"});
            WatchRuleImpl.getOrCreate((Entity)owner, (Entity)t, (int)RuleType.getMaskWithPin());
        }
        return t;
    }

    public static Iterable<Entity> findByName(String name) {
        StarService starService = (StarService)ServiceLocator.getBean((String)"starService");
        if (IssueTagImpl.eq_l00flc_a0b0f(name, starService.getStarName())) {
            return QueryOperations.empty((String)"IssueTag");
        }
        return IssueTagImpl.getAllVisibleTagsUnsorted(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Iterable<Entity>)QueryOperations.query(null, (String)"IssueTag", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
    }

    public static Entity findTagByName(String name) {
        StarService starService = (StarService)ServiceLocator.getBean((String)"starService");
        if (IssueTagImpl.eq_l00flc_a0b0g(name, starService.getStarName())) {
            return null;
        }
        return QueryOperations.getFirst(IssueTagImpl.getAllVisibleTagsUnsorted(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Iterable<Entity>)QueryOperations.query(null, (String)"IssueTag", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name)))));
    }

    public static Iterable<Entity> getOwn(Entity user) {
        return AssociationSemantics.getToMany((Entity)user, (String)"tags");
    }

    public static Iterable<Entity> getAllVisibleTags(Entity user) {
        Iterable<Entity> explicit = IssueTagImpl.whereExplicit((Iterable<Entity>)QueryOperations.queryGetAll((String)"IssueTag"));
        TreeKeepingEntityIterable own = QueryOperations.query(explicit, (String)"IssueTag", (NodeBase)new LinkEqual("owner", user));
        TreeKeepingEntityIterable notOwn = QueryOperations.query(explicit, (String)"IssueTag", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("owner", user)));
        Iterable<Entity> result = IssueTagImpl.getOrdered(user, (Iterable<Entity>)own, (Iterable<Entity>)notOwn);
        return result;
    }

    public static Iterable<Entity> getAllVisibleTagsUnsorted(Entity user) {
        return IssueTagImpl.getAllVisibleTagsUnsorted(user, IssueTagImpl.whereExplicit((Iterable<Entity>)QueryOperations.queryGetAll((String)"IssueTag")));
    }

    public static Iterable<Entity> getAllVisibleTagsUnsorted(Entity user, Iterable<Entity> tags) {
        TreeKeepingEntityIterable own = QueryOperations.query(tags, (String)"IssueTag", (NodeBase)new LinkEqual("owner", user));
        TreeKeepingEntityIterable notOwn = QueryOperations.query(tags, (String)"IssueTag", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("owner", user)));
        Iterable result = QueryOperations.concat((Iterable)own, WatchFolderImpl.whereSharedIsVisible(user, (Iterable<Entity>)notOwn));
        return result;
    }

    public static Iterable<Entity> getTags(Entity user) {
        return IssueTagImpl.prependImplicit(user, IssueTagImpl.getAllVisibleTags(user));
    }

    public static List<Entity> getTagsInMemory(Entity user) {
        Iterable<Entity> explicit = IssueTagImpl.whereExplicit((Iterable<Entity>)QueryOperations.queryGetAll((String)"IssueTag"));
        TreeKeepingEntityIterable own = QueryOperations.query(explicit, (String)"IssueTag", (NodeBase)new LinkEqual("owner", user));
        TreeKeepingEntityIterable notOwn = QueryOperations.query(explicit, (String)"IssueTag", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("owner", user)));
        own = QueryOperations.query((Iterable)Sequence.fromIterable((Iterable)own).toListSequence(), (String)"IssueTag", (NodeBase)new SortByProperty(null, "name", true));
        TreeKeepingEntityIterable shared = QueryOperations.query((Iterable)Sequence.fromIterable(WatchFolderImpl.whereSharedIsVisible(user, (Iterable<Entity>)notOwn)).toListSequence(), (String)"WatchFolder", (NodeBase)new SortByProperty(null, "name", true));
        IListSequence result = ListSequence.fromList(new ArrayList());
        Entity star = ((StarService)ServiceLocator.getBean((String)"starService")).findStar(user);
        if (!EntityOperations.equals((Entity)star, null)) {
            ListSequence.fromList((List)result).addElement((Object)star);
        }
        ListSequence.fromList((List)result).addSequence(Sequence.fromIterable((Iterable)own));
        ListSequence.fromList((List)result).addSequence(Sequence.fromIterable((Iterable)shared));
        return result;
    }

    private static Iterable<Entity> prependImplicit(Entity user, Iterable<Entity> result) {
        Entity star = ((StarService)ServiceLocator.getBean((String)"starService")).findStar(user);
        if (!EntityOperations.equals((Entity)star, null)) {
            result = QueryOperations.concat((Iterable)QueryOperations.singleton((Entity)star), result);
        }
        return result;
    }

    public static Entity getTag(Entity issue, String name) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"tags"), (String)"IssueTag", (NodeBase)new And((NodeBase)new LinkEqual("owner", ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()), (NodeBase)new PropertyEqual("name", (Comparable)((Object)name)))));
    }

    public static Entity addTag(Entity issue, Entity user, String name) {
        Entity issueTag = IssueTagImpl.getTag(user, name, true);
        if (!EntityOperations.equals((Entity)issueTag, null) && ((IssueTagImpl)DnqUtils.getPersistentClassInstance((Entity)issueTag, (String)"IssueTag")).canTagUntagIssue(issue, user, issueTag)) {
            UndirectedAssociationSemantics.createManyToMany((Entity)issueTag, (String)"issues", (String)"tags", (Entity)issue);
        }
        return issueTag;
    }

    public static Entity addTag(Entity issue, String issueTagName) {
        return IssueTagImpl.addTag(issue, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), issueTagName);
    }

    public static Entity removeTag(Entity issue, String issueTagName) {
        Entity tag = IssueTagImpl.getTag(issue, issueTagName);
        if (!EntityOperations.equals((Entity)tag, null)) {
            ((IssueTagImpl)DnqUtils.getPersistentClassInstance((Entity)tag, (String)"IssueTag")).untag(issue, tag);
        }
        return tag;
    }

    @Nullable
    public static Entity findById(String id) {
        return DnqUtils.as((Object)IssueTagImpl.fromId("IssueTag", id), (String)"IssueTag");
    }

    protected static DnqUtils.QueryingEntityCreator getEntityCreator(String entityType, Entity owner, String name, final Set<String> queriedParams) {
        final DnqUtils.QueryingEntityCreator parent = DnqUtils.getEntityCreator((String)entityType, queriedParams);
        final Entity __var__owner = owner;
        final String __var__name = name;
        return new DnqUtils.QueryingEntityCreator(entityType){

            public Iterable<Entity> query() {
                Iterable result = parent.query();
                if (queriedParams.contains("owner")) {
                    result = QueryOperations.query((Iterable)result, (String)"IssueTag", (NodeBase)new LinkEqual("owner", __var__owner));
                }
                if (queriedParams.contains("name")) {
                    result = QueryOperations.query((Iterable)result, (String)"IssueTag", (NodeBase)new PropertyEqual("name", (Comparable)((Object)__var__name)));
                }
                return result;
            }

            public void created(@NotNull Entity entity) {
                parent.created(entity);
                UndirectedAssociationSemantics.setManyToOne((Entity)__var__owner, (String)"tags", (String)"owner", (Entity)entity);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)__var__name), String.class);
            }
        };
    }

    public static Entity findOrCreate(Entity owner, String name, String[] queriedParams) {
        return IssueTagImpl.getEntityCreator(__ENTITY_TYPE__, owner, name, BasePersistentClassImpl.buildSet((Object[])queriedParams)).create((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore"));
    }

    private static boolean eq_l00flc_a0b0f(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_l00flc_a0b0g(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

