/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.shortcuts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.smartui.shortcuts.Shortcuts;
import jetbrains.charisma.smartui.shortcuts.ShortcutsDecoderEncoder;
import jetbrains.charisma.smartui.shortcuts.SuppliedShortcuts;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyContainer;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyStroke;
import jetbrains.mps.webr.htmlComponent.runtime.KeyContainer;
import jetbrains.mps.webr.htmlComponent.runtime.LocalizedKeyStroke;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import org.jetbrains.annotations.Nullable;

public class ShortcutsUtil {
    private static Shortcuts DEFAULT_SHORTCUTS = null;

    public static Shortcuts exportCurrent() throws IOException {
        final Shortcuts shortcuts = new Shortcuts();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                shortcuts.setTitle((String)PrimitiveAssociationSemantics.get((Entity)SuppliedShortcuts.getCurrentShortcutsJSON(), (String)"title", String.class, null));
            }
        });
        shortcuts.setShortcuts((List<Shortcuts.Shortcut>)ListSequence.fromList(new ArrayList()));
        for (IKeyStroke lks : ((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStrokes()) {
            shortcuts.getShortcuts().add(ShortcutsDecoderEncoder.getShortcut(ShortcutsUtil.as_4m4d2v_a0a0a0a3a0(lks, LocalizedKeyStroke.class)));
        }
        return shortcuts;
    }

    public static Shortcuts readShortcuts(InputStream data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Shortcuts shortcuts = (Shortcuts)mapper.readValue(data, Shortcuts.class);
        return shortcuts;
    }

    private static void applyConcrete(Shortcuts shortcuts) {
        List keys = ((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStrokes();
        for (Shortcuts.Shortcut shc : shortcuts.getShortcuts()) {
            final LocalizedKeyStroke ks = ShortcutsDecoderEncoder.getLocalizedKeyStroke(shc);
            if (ks == null) continue;
            ListSequence.fromList((List)keys).removeWhere((_FunctionTypes._return_P1_E0)new IWhereFilter<IKeyStroke>(){

                public boolean accept(IKeyStroke it) {
                    return it.getName().equals(ks.getName());
                }
            }).addElement((Object)ks);
        }
        ShortcutsUtil.as_4m4d2v_a0a2a2((IKeyContainer)ServiceLocator.getBean((String)"keyContainer"), KeyContainer.class).setKeyStrokes(keys);
    }

    public static void applyDefault() throws IOException {
        if (DEFAULT_SHORTCUTS == null) {
            DEFAULT_SHORTCUTS = ShortcutsUtil.exportCurrent();
        } else {
            ShortcutsUtil.applyConcrete(DEFAULT_SHORTCUTS);
        }
    }

    public static void apply(@Nullable InputStream data) throws IOException {
        ShortcutsUtil.applyDefault();
        if (data != null) {
            ShortcutsUtil.applyConcrete(ShortcutsUtil.readShortcuts(data));
        }
    }

    public static void applyCurrent() throws IOException {
        Entity json = SuppliedShortcuts.getCurrentShortcutsJSON();
        if (!EntityOperations.equals((Entity)json, (Object)SuppliedShortcuts.getDefaults())) {
            ShortcutsUtil.apply(PrimitiveAssociationSemantics.getBlob((Entity)AssociationSemantics.getToOne((Entity)json, (String)"data"), (String)"content"));
        } else {
            ShortcutsUtil.apply(null);
        }
    }

    public static Shortcuts validate(String name, InputStream dataStream) {
        if (name.endsWith(".json")) {
            Shortcuts shc;
            try {
                shc = ShortcutsUtil.readShortcuts(dataStream);
            }
            catch (Exception ioe) {
                throw new LogicException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ImportShortcutsDialog.JSON_file_is_not_valid", new Object[0]) + ioe.getMessage());
            }
            return shc;
        }
        throw new LogicException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ImportShortcutsDialog.Please_select_JSON_file_json", new Object[0]));
    }

    private static <T> T as_4m4d2v_a0a0a0a3a0(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_4m4d2v_a0a2a2(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }
}

