/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.shortcuts;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.charisma.misc.FileUtil;
import jetbrains.charisma.smartui.shortcuts.Shortcuts;
import jetbrains.charisma.smartui.shortcuts.ShortcutsJSONImpl;
import jetbrains.charisma.smartui.shortcuts.ShortcutsUtil;
import jetbrains.charisma.smartui.shortcuts.SuppliedShortcutWrapper;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.Resource;

public class SuppliedShortcuts {
    static Entity getCurrentShortcutsJSON() {
        String current = (String)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"serverShortcuts", String.class, null);
        if (current != null && current.length() > 0 && Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"ShortcutsJSON")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

            public String select(Entity it) {
                return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"id", String.class, null);
            }
        }).contains((Object)current)) {
            return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"ShortcutsJSON", (NodeBase)new PropertyEqual("id", (Comparable)((Object)current))));
        }
        return SuppliedShortcuts.getDefaults();
    }

    static String getCurrentShortcutsId() {
        return (String)PrimitiveAssociationSemantics.get((Entity)SuppliedShortcuts.getCurrentShortcutsJSON(), (String)"id", String.class, null);
    }

    static Iterable<String> getAvailableShortcutsList() {
        return Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"ShortcutsJSON")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

            public String select(Entity it) {
                return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"id", String.class, null);
            }
        });
    }

    private static Iterable<Resource> getResources() {
        try {
            return Sequence.fromArray((Object[])ServiceLocator.getResources((String)"classpath*:**/shortcuts/*.json"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static File getShortcutsFile(Resource resource) throws IOException, FileNotFoundException {
        File shortcutsFile;
        if ("file".equals(resource.getURL().getProtocol())) {
            shortcutsFile = resource.getFile();
        } else {
            shortcutsFile = FileUtil.createTempFile(resource.getFilename());
            FileOutputStream out = new FileOutputStream(shortcutsFile);
            IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)out);
            out.close();
        }
        return shortcutsFile;
    }

    public static void install() {
        try {
            for (final Resource resource : Sequence.fromIterable(SuppliedShortcuts.getResources())) {
                _Txn.run((_FunctionTypes._void_P0_E1)new _FunctionTypes._void_P0_E1<IOException>(){

                    public void invoke() throws IOException {
                        Shortcuts shc = ShortcutsUtil.readShortcuts(resource.getInputStream());
                        Entity json = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"ShortcutsJSON", (NodeBase)new LinksEqualDecorator("data", (NodeBase)new PropertyEqual("name", (Comparable)((Object)resource.getFilename())), "PersistentFile")));
                        if (EntityOperations.equals((Entity)json, null)) {
                            json = ShortcutsJSONImpl.constructor(SuppliedShortcuts.getShortcutsFile(resource), resource.getFilename(), shc.getTitle());
                        } else {
                            ((ShortcutsJSONImpl)DnqUtils.getPersistentClassInstance((Entity)json, (String)"ShortcutsJSON")).update(SuppliedShortcuts.getShortcutsFile(resource), resource.getFilename(), shc.getTitle(), json);
                        }
                    }
                });
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Entity manuallyInstall(InputStream file, String fileName, String title) {
        Entity updatedItem;
        Entity withSameFileName = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"ShortcutsJSON", (NodeBase)new LinksEqualDecorator("data", (NodeBase)new PropertyEqual("name", (Comparable)((Object)fileName)), "PersistentFile")));
        Entity withSameTitle = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"ShortcutsJSON", (NodeBase)new PropertyEqual("title", (Comparable)((Object)title))));
        if (!EntityOperations.equals((Entity)withSameFileName, null)) {
            PrimitiveAssociationSemantics.setBlob((Entity)AssociationSemantics.getToOne((Entity)withSameFileName, (String)"data"), (String)"content", (InputStream)file);
            PrimitiveAssociationSemantics.set((Entity)withSameFileName, (String)"title", (Comparable)((Object)title), String.class);
            if (!EntityOperations.equals((Entity)withSameTitle, null) && !EntityOperations.equals((Entity)withSameTitle, (Object)withSameFileName)) {
                EntityOperations.remove((Entity)withSameTitle);
            }
            updatedItem = withSameFileName;
        } else if (!EntityOperations.equals((Entity)withSameTitle, null)) {
            updatedItem = ShortcutsJSONImpl.constructor(file, title);
            if (SuppliedShortcuts.eq_b5mbfb_a0a1a0a0d0g(PrimitiveAssociationSemantics.get((Entity)SuppliedShortcuts.getCurrentShortcutsJSON(), (String)"title", String.class, null), PrimitiveAssociationSemantics.get((Entity)updatedItem, (String)"title", String.class, null)) || SuppliedShortcuts.eq_b5mbfb_a0a1a0a0d0g_0(PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)SuppliedShortcuts.getCurrentShortcutsJSON(), (String)"data"), (String)"name", String.class, null), fileName)) {
                PrimitiveAssociationSemantics.set((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"serverShortcuts", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)updatedItem, (String)"id", String.class, null)), String.class);
            }
            EntityOperations.remove((Entity)withSameTitle);
        } else {
            updatedItem = ShortcutsJSONImpl.constructor(file, title);
        }
        return updatedItem;
    }

    public static void delete(String id) throws IOException {
        Entity toBeDeleted = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"ShortcutsJSON", (NodeBase)new PropertyEqual("id", (Comparable)((Object)id))));
        if (!EntityOperations.equals((Entity)toBeDeleted, null) && !SuppliedShortcuts.eq_b5mbfb_a0a0b0h(toBeDeleted, SuppliedShortcuts.getDefaults())) {
            EntityOperations.remove((Entity)toBeDeleted);
        }
        if (SuppliedShortcuts.eq_b5mbfb_a0c0h(id, PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"serverShortcuts", String.class, null))) {
            ShortcutsUtil.applyDefault();
        }
    }

    @NotNull
    public static Entity getDefaults() {
        return ((SuppliedShortcutWrapper)ServiceLocator.getBean((String)"defaultSuppliedShortcuts")).json;
    }

    private static boolean eq_b5mbfb_a0a1a0a0d0g(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_b5mbfb_a0a1a0a0d0g_0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_b5mbfb_a0a0b0h(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_b5mbfb_a0c0h(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

