/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.watchFolder;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.charisma.smartui.watchFolder.TimerControlledObject;
import jetbrains.exodus.core.dataStructures.decorators.HashSetDecorator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Period;

public class FolderCounts {
    protected static Log log = LogFactory.getLog(FolderCounts.class);
    public TimerControlledObject timer;
    public HashSetDecorator<Entity> processing = new HashSetDecorator();
    private Map<Entity, Iterable<Entity>> issuesByFolder = MapSequence.fromMap(new HashMap());
    private State state;

    public FolderCounts(TimerControlledObject timer) {
        this.timer = timer;
        this.state = State.STARTED;
    }

    public String count(Entity folder) {
        int c = QueryOperations.roughCount(IssueFolderUtil.getOrderedIssuesProvider(folder).getIssues(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), new Context(), false));
        if (c == -1) {
            this.requestCount(folder);
        }
        return c != -1 ? String.valueOf(c) : "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestCount(Entity folder) {
        if (!EntityOperations.isNew((Entity)folder)) {
            FolderCounts folderCounts = this;
            synchronized (folderCounts) {
                this.processing.add((Object)folder);
                this.countRequested(folder);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Count for unflushed WatchFolder requested", new Throwable());
        }
        return "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Map<Entity, Integer> processedFolders) {
        FolderCounts folderCounts = this;
        synchronized (folderCounts) {
            ISetSequence removed = SetSequence.fromSet(new HashSet());
            for (Entity folder : SetSequence.fromSet(this.processing)) {
                int c = -1;
                if (!EntityOperations.equals((Entity)folder, null) && !EntityOperations.isRemoved((Entity)folder)) {
                    Iterable<Entity> issues = (Iterable<Entity>)MapSequence.fromMap(this.issuesByFolder).get((Object)folder);
                    boolean canCache = false;
                    if (issues == null) {
                        canCache = true;
                        issues = IssueFolderUtil.getOrderedIssuesProvider(folder).getIssues(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), new Context(), false);
                    }
                    if ((c = QueryOperations.roughCount((Iterable)issues)) == -1 && canCache) {
                        MapSequence.fromMap(this.issuesByFolder).put((Object)folder, issues);
                    }
                } else {
                    SetSequence.fromSet((Set)removed).addElement((Object)folder);
                }
                if (c == -1) continue;
                MapSequence.fromMap(processedFolders).put((Object)folder, (Object)c);
            }
            this.processing.removeAll((Collection)MapSequence.fromMap(processedFolders).keySet());
            this.processing.removeAll((Collection)removed);
            for (Entity folder : MapSequence.fromMap(processedFolders).keySet()) {
                MapSequence.fromMap(this.issuesByFolder).removeKey((Object)folder);
            }
            this.updateFinished();
        }
    }

    public void countRequested(Entity folder) {
        switch (this.state) {
            case STARTED: {
                break;
            }
            case STOPPING: {
                break;
            }
            case STOPPED: {
                this.processing.add((Object)folder);
                this.state = State.STARTING;
                break;
            }
            case STARTING: {
                break;
            }
        }
    }

    public void updateFinished() {
        switch (this.state) {
            case STARTED: {
                if (!this.processing.isEmpty()) break;
                this.state = State.STOPPING;
                break;
            }
            case STOPPING: {
                break;
            }
            case STOPPED: {
                break;
            }
            case STARTING: {
                break;
            }
        }
    }

    public void executeCommand() {
        switch (this.state) {
            case STARTED: {
                break;
            }
            case STOPPING: {
                this.timer.stop();
                this.state = State.STOPPED;
                break;
            }
            case STOPPED: {
                break;
            }
            case STARTING: {
                this.timer.start(Period.seconds((int)5));
                this.state = State.STARTED;
                break;
            }
        }
    }

    public boolean isInState(State state) {
        return this.state == state;
    }

    public State _state() {
        return this.state;
    }

    public static enum State {
        STARTED,
        STOPPING,
        STOPPED,
        STARTING;

    }
}

