/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.watchFolder;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterator;
import jetbrains.youtrack.api.parser.OrderedEntitiesListener;
import org.jetbrains.annotations.NotNull;

public class InMemoryStableSortIterable
implements Iterable<Entity> {
    @NotNull
    private final EntityIterableBase propIndex;
    private final Iterable<Entity> source;
    private final int sourceTypeId;
    private final PersistentEntityStore persistentStore;
    private final TransientEntityStore transientStore;
    private final OrderedEntitiesListener callback;

    public InMemoryStableSortIterable(PersistentEntityStore persistentStore, TransientEntityStore transientStore, @NotNull EntityIterableBase propIndex, Iterable<Entity> source, int sourceTypeId, OrderedEntitiesListener callback) {
        this.persistentStore = persistentStore;
        this.transientStore = transientStore;
        this.propIndex = propIndex;
        this.source = source;
        this.sourceTypeId = sourceTypeId;
        this.callback = callback;
    }

    public Iterable<Entity> getSource() {
        return this.source;
    }

    @Override
    public Iterator<Entity> iterator() {
        return new StableSortIterator((PropertyValueIterator)this.propIndex.iterator(), this.transientStore.getThreadSession());
    }

    @NotNull
    private Map<EntityId, Integer> getRightOrder() {
        HashMap result = new HashMap();
        int position = 0;
        for (Entity entity : this.source) {
            if (EntityOperations.equals((Entity)entity, null)) {
                result.put(null, ++position);
                continue;
            }
            EntityId entityId = entity.getId();
            if (this.sourceTypeId != entityId.getTypeId()) continue;
            result.put(entityId, ++position);
        }
        return result;
    }

    private final class StableSortIterator
    implements Iterator<Entity> {
        private final TransientStoreSession session;
        @NotNull
        private final PropertyValueIterator propertyValueIterator;
        private final PriorityQueue<EntityId> sameValueQueue;
        private final Map<EntityId, Integer> rightOrder;
        private EntityId nextId;
        private Comparable lastValue;
        private EntityId lastEntityId;
        private boolean hasNext;
        private boolean hasNextValid;
        private boolean customOrderFinished = false;

        private StableSortIterator(PropertyValueIterator propertyValueIterator, TransientStoreSession session) {
            this.propertyValueIterator = propertyValueIterator;
            this.session = session;
            this.sameValueQueue = new PriorityQueue<EntityId>(4, new Comparator<EntityId>(){

                @Override
                public int compare(EntityId o1, EntityId o2) {
                    return (Integer)StableSortIterator.this.rightOrder.get(o1) - (Integer)StableSortIterator.this.rightOrder.get(o2);
                }
            });
            this.rightOrder = InMemoryStableSortIterable.this.getRightOrder();
            this.nextId = null;
            this.lastValue = null;
            this.lastEntityId = null;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNextValid) {
                this.hasNext = this.hasNextImpl();
                this.hasNextValid = true;
            }
            return this.hasNext;
        }

        @Override
        public Entity next() {
            EntityId resultId = this.hasNext() ? this.nextId : null;
            this.hasNextValid = false;
            this.callbackIfNeeded();
            if (resultId == null) {
                return null;
            }
            Entity resultEntity = InMemoryStableSortIterable.this.persistentStore.getEntity(resultId);
            if (EntityOperations.equals((Entity)resultEntity, null)) {
                return null;
            }
            return resultId == null ? null : this.session.newEntity(resultEntity);
        }

        protected boolean hasNextImpl() {
            PriorityQueue<EntityId> sameValueQueue = this.sameValueQueue;
            Map<EntityId, Integer> rightOrder = this.rightOrder;
            if (sameValueQueue.isEmpty()) {
                Comparable lastValue = this.lastValue;
                if (lastValue != null) {
                    sameValueQueue.offer(this.lastEntityId);
                    this.lastValue = null;
                    this.lastEntityId = null;
                }
                while (this.propertyValueIterator.hasNext()) {
                    EntityId nextId = this.propertyValueIterator.nextId();
                    if (!rightOrder.containsKey(nextId)) continue;
                    Comparable currentValue = this.propertyValueIterator.currentValue();
                    if (currentValue != null && lastValue != null && lastValue.compareTo(currentValue) != 0) {
                        this.lastValue = currentValue;
                        this.lastEntityId = nextId;
                        break;
                    }
                    lastValue = currentValue;
                    sameValueQueue.offer(nextId);
                }
            }
            block1: while (true) {
                if (!sameValueQueue.isEmpty()) {
                    EntityId id;
                    this.nextId = id = sameValueQueue.poll();
                    rightOrder.remove(id);
                    return true;
                }
                if (rightOrder.isEmpty()) break;
                Iterator<EntityId> iterator = rightOrder.keySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block1;
                    EntityId entityId = iterator.next();
                    sameValueQueue.offer(entityId);
                }
                break;
            }
            if (rightOrder.containsKey(null)) {
                rightOrder.remove(null);
                this.nextId = null;
                return true;
            }
            return false;
        }

        private void callbackIfNeeded() {
            if (InMemoryStableSortIterable.this.callback != null && !this.customOrderFinished) {
                if (this.lastEntityId != null && this.lastValue != null) {
                    InMemoryStableSortIterable.this.callback.onEntityOrdered(this.lastEntityId);
                } else {
                    this.customOrderFinished = true;
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

