/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.statistics;

import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.statistics.AssignType;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.statistics.StatisticsService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;

public class StatisticsUtil {
    private static String MPS_FSI = "mps-siv";
    private static String MPS_NEW_ISSUE = "mps-new-issue";
    static final StatisticsFeatureDescription buttonFSI = new StatisticsFeatureDescription(MPS_FSI, "button-assignee");
    static final StatisticsFeatureDescription commandFSI = new StatisticsFeatureDescription(MPS_FSI, "command-assignee");
    static final StatisticsFeatureDescription comboboxFSI = new StatisticsFeatureDescription(MPS_FSI, "combobox-assignee");
    static final StatisticsFeatureDescription buttonNEW = new StatisticsFeatureDescription(MPS_NEW_ISSUE, "button-assignee");
    static final StatisticsFeatureDescription commandNEW = new StatisticsFeatureDescription(MPS_NEW_ISSUE, "command-assignee");
    static final StatisticsFeatureDescription comboboxNEW = new StatisticsFeatureDescription(MPS_NEW_ISSUE, "combobox-assignee");
    protected static Log log = LogFactory.getLog(StatisticsUtil.class);

    public static String getToolbarAction(String action) {
        String category = StatisticsUtil.getToolBarCategory();
        return category + ":" + action;
    }

    public static String getToolBarCategory() {
        if (BaseApplication.getRequest().getRequestURI().contains("/issues")) {
            return "topToolBarIssueList";
        }
        return "topToolBarIssue";
    }

    public static boolean isFSI() {
        String uri = BaseApplication.getRequest().getRequestURI();
        return uri.contains("/issue") && !uri.contains("/issues");
    }

    public static void trackAssignAction(Entity issue, AssignType type, boolean fsi) {
        if (!fsi && !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isDraft(issue)) {
            return;
        }
        StatisticsFeatureDescription feature = type.getFeature(fsi);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Track assign action: " + feature));
        }
        ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance(feature);
    }
}

